#***********************************************************************************************************************************************
#*  
#*  (C) 2011    Ewa Witek     Uniwersytet Ekonomiczny w Katowicach
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

set.seed(123)
library("flexmix")
data("bioChemists")
options(OutDec=",")
mix_wybor<-stepFlexmix(art ~.,data=bioChemists,k=1:8,model=FLXMRglm(family="poisson"))
wybor_BIC<-getModel(mix_wybor,"BIC")
Model_mieszanek1<-FLXMRglmfix(family="poisson")
Model_mieszanek_parametry_1<-flexmix(art~fem+mar+kid5+phd+ment,data=bioChemists,cluster=posterior(wybor_BIC),model=Model_mieszanek1)
Model_mieszanek2 <- FLXMRglmfix(family="poisson",fixed=~ment)
Model_mieszanek_parametry_2<-flexmix(art~fem+mar+kid5+phd,data=bioChemists,cluster=posterior(Model_mieszanek_parametry_1),model=Model_mieszanek2)
Model_mieszanek3<-FLXMRglmfix(family="poisson",fixed=~ment)
Model_mieszanek_parametry_3<-flexmix(art~1,data=bioChemists,cluster=posterior(Model_mieszanek_parametry_1),concomitant=FLXPmultinom(~fem),model=Model_mieszanek3)
print("Oszacowane parametry modelu mieszanek 3:")
print(parameters(Model_mieszanek_parametry_3))
print("Parametry dla zmiennej towarzyszcej:")
summary(refit(Model_mieszanek_parametry_3),which="concomitant")