#*****************************************************************************************************************************************************
#*  
#*  (C) 2011     Marek Walesiak     Uniwersytet Ekonomiczny we Wrocawiu
#*
#*  Skrypt do ksiki:
#*  Walesiak M., Uoglniona miara odlegoci GDM w statystycznej analizie wielowymiarowej z wykorzystaniem programu R, Wydawnictwo UE, Wrocaw 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#*****************************************************************************************************************************************************

library(clusterSim)
x<-read.csv2("Warunki_mieszkaniowe_2008.csv",header=TRUE,row.names=1)
options(OutDec=",")
res<-pattern.GDM1(x,performanceVariable=c("s","s","s","s","s","s","d","d","s","s"),
   scaleType="r",nomOptValues=NULL,weightsType="equal",normalization="n1",patternType="upper",
   patternCoordinates="manual",patternManual=c(100,100,100,100,100,"max","min","min","max","max"),
   nominalTransfMethod=NULL)
print("Uporzdkowanie wojewdztw od najlepszego do najgorszego wedug wartoci miary GDM1",quote=FALSE)
print(res$sortedDistances)
# Prezentacja graficzna wynikw porzdkowania liniowego
gdm_p<-res$distances
plot(cbind(gdm_p,gdm_p),xlim=c(min(gdm_p),max(gdm_p)),ylim=c(min(gdm_p),max(gdm_p)),xaxt="n",
   xlab="",ylab="Odlegoci GDM1 od obiektu wzorca",lwd=1.6,las=1)
axis(1,at=gdm_p,labels=names(gdm_p),las=2,cex.axis=0.5)
