#*****************************************************************************************************************************************************
#*  
#*  (C) 2011     Marek Walesiak     Uniwersytet Ekonomiczny we Wrocawiu
#*
#*  Skrypt do ksiki:
#*  Walesiak M., Uoglniona miara odlegoci GDM w statystycznej analizie wielowymiarowej z wykorzystaniem programu R, Wydawnictwo UE, Wrocaw 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#*****************************************************************************************************************************************************

library(clusterSim)
set.seed(123) #Ustawienie generatora liczb losowych
#Wczytanie zbioru danych
xx<-read.csv2("Dane_zp_2007.csv",header=TRUE)
x<-as.matrix(xx[, 2:ncol(xx)])
options(OutDec=",")
#Wybr formuy normalizacji wartoci zmiennych
z<-data.Normalization(x,type="n1")
#Wybr miary odlegoci
z<-as.data.frame(z)
d<-dist.GDM(z,method="GDM1")
print("Ustalenie liczby klas z wykorzystaniem indeksu gap",quote=FALSE)
min_liczba_klas<-2
max_liczba_klas<-10
min<-0
clopt<-NULL
wyn<-NULL
wyniki<-array(0,c(max_liczba_klas-min_liczba_klas+1,2))
wyniki[,1]<-min_liczba_klas:max_liczba_klas
znaleziono<-FALSE
for(liczba_klas in min_liczba_klas:max_liczba_klas){
  cl1<-pam(d,liczba_klas,diss=TRUE)
  cl2<-pam(d,liczba_klas+1,diss=TRUE)
  clall<-cbind(cl1$clustering,cl2$clustering)
  Gap<-index.Gap(z,clall,reference.distribution="pc",B=10,method="pam")
  wyniki[liczba_klas-min_liczba_klas+1,2]<-diffu<-Gap$diffu
  if((wyniki[liczba_klas-min_liczba_klas+1,2]>=0)&&(!znaleziono)){
    lk<-liczba_klas
    min<-diffu
    clopt<-cl1$cluster
    wyn<-cl1$clusinfo
    znaleziono<-TRUE
  }
}
if(znaleziono){
  print(paste("Minimalna liczba klas dla diffu>=0 wynosi",lk,"dla diffu=",round(min, 4)),quote=FALSE)
}else{
  print("Nie znalazem klasyfikacji, dla ktrej diffu>=0",quote=FALSE)
}
#Zapisanie do pliku diffu.csv wartoci indeksu gap
write.table(wyniki,file="diffu.csv",sep=";",dec=",",row.names=TRUE,col.names=FALSE)
print("Prezentacja klasyfikacji wynikowej",quote=FALSE)
cl_wyn1<-data.frame(xx[, 1],clopt)
colnames(cl_wyn1)<-c("wojewdztwa","klasa")
print(cl_wyn1)
print("Prezentacja klasyfikacji wynikowej - uporzdkowana",quote=FALSE)
cl_wyn2<-cl_wyn1[order(cl_wyn1[,"klasa"],decreasing=FALSE),]
cl_wyn2<-data.frame(cl_wyn2)
print(cl_wyn2)
#Zapisanie do pliku clusinfo.csv dodatkowych informacji o wyodrbnionych klasach
write.table(wyn,file="clusinfo.csv",sep=";",dec=",",row.names=TRUE,col.names=TRUE)
plot(wyniki,type="p",pch=0,xlab="Liczba klas",ylab="diffu",xaxt="n")
abline(h=0,untf=FALSE)
axis(1,c(min_liczba_klas:max_liczba_klas))
desc<-cluster.Description(x,clopt,"population")
print("rednie arytmetyczne",quote=FALSE)
print(desc[,,1])
print("Odchylenia standardowe",quote=FALSE)
print(desc[,,2])
