/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolverImpl;

public class SecantSolver
extends UnivariateRealSolverImpl
implements Serializable {
    static final long serialVersionUID = 1984971194738974867L;

    public SecantSolver(UnivariateRealFunction f) {
        super(f, 100, 1.0E-6);
    }

    public double solve(double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(min, max);
    }

    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        int i;
        this.clearResult();
        this.verifyBracketing(min, max, this.f);
        double x0 = min;
        double x1 = max;
        double y0 = this.f.value(x0);
        double y1 = this.f.value(x1);
        double x2 = x0;
        double y2 = y0;
        double oldDelta = x2 - x1;
        for (i = 0; i < this.maximalIterationCount; ++i) {
            double delta;
            if (Math.abs(y2) < Math.abs(y1)) {
                x0 = x1;
                x1 = x2;
                x2 = x0;
                y0 = y1;
                y1 = y2;
                y2 = y0;
            }
            if (Math.abs(y1) <= this.functionValueAccuracy) {
                this.setResult(x1, i);
                return this.result;
            }
            if (Math.abs(oldDelta) < Math.max(this.relativeAccuracy * Math.abs(x1), this.absoluteAccuracy)) {
                this.setResult(x1, i);
                return this.result;
            }
            if (Math.abs(y1) > Math.abs(y0)) {
                delta = 0.5 * oldDelta;
            } else {
                delta = (x0 - x1) / (1.0 - y0 / y1);
                if (delta / oldDelta > 1.0) {
                    delta = 0.5 * oldDelta;
                }
            }
            x0 = x1;
            y0 = y1;
            y1 = this.f.value(x1 += delta);
            if (y1 > 0.0 == y2 > 0.0) {
                x2 = x0;
                y2 = y0;
            }
            oldDelta = x2 - x1;
        }
        throw new ConvergenceException("Maximal iteration number exceeded" + i);
    }
}

