/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHabColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J)\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/github/ajalt/colormath/model/LCHabColorSpaceImpl;", "Lcom/github/ajalt/colormath/model/LCHabColorSpace;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "<init>", "(Lcom/github/ajalt/colormath/WhitePoint;)V", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "name", "", "getName", "()Ljava/lang/String;", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "convert", "Lcom/github/ajalt/colormath/model/LCHab;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "toString", "invoke", "l", "", "c", "h", "alpha", "hashCode", "", "equals", "", "other", "", "component1", "copy", "colormath"})
@SourceDebugExtension(value={"SMAP\nLCHab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LCHab.kt\ncom/github/ajalt/colormath/model/LCHabColorSpaceImpl\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n35#2,4:84\n26#2:88\n15#2,13:89\n1#3:102\n*S KotlinDebug\n*F\n+ 1 LCHab.kt\ncom/github/ajalt/colormath/model/LCHabColorSpaceImpl\n*L\n32#1:84,4\n33#1:88\n33#1:89,13\n33#1:102\n*E\n"})
final class LCHabColorSpaceImpl
implements LCHabColorSpace {
    @NotNull
    private final WhitePoint whitePoint;
    @NotNull
    private final List<ColorComponentInfo> components;

    public LCHabColorSpaceImpl(@NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter(whitePoint, "whitePoint");
        this.whitePoint = whitePoint;
        ColorComponentInfo[] colorComponentInfoArray = new ColorComponentInfo[]{new ColorComponentInfo("L", false, 0.0f, 100.0f), new ColorComponentInfo("C", false, 0.0f, 150.0f), new ColorComponentInfo("H", true, 0.0f, 360.0f)};
        this.components = ColorSpaceUtilsKt.componentInfoList(colorComponentInfoArray);
    }

    @Override
    @NotNull
    public WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    @Override
    @NotNull
    public String getName() {
        return "LCHab";
    }

    @Override
    @NotNull
    public List<ColorComponentInfo> getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public LCHab convert(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        WhitePointColorSpace $this$adaptToThis$iv = this;
        boolean $i$f$adaptToThis = false;
        ColorSpace<?> colorSpace = color.getSpace();
        Object object = colorSpace instanceof WhitePointColorSpace ? (WhitePointColorSpace)colorSpace : null;
        if (object == null || (object = object.getWhitePoint()) == null) {
            object = Illuminant.INSTANCE.getD65();
        }
        if (Intrinsics.areEqual(object, $this$adaptToThis$iv.getWhitePoint())) {
            Color it = color;
            boolean bl = false;
            color2 = it.toLCHab();
        } else {
            Color it = color.toXYZ().adaptTo(XYZKt.XYZColorSpace($this$adaptToThis$iv.getWhitePoint()));
            boolean bl = false;
            color2 = it.toLCHab();
        }
        return (LCHab)color2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LCHab create(@NotNull float[] components) {
        void p3;
        void p2;
        void p1;
        float f;
        Intrinsics.checkNotNullParameter(components, "components");
        ColorSpace $this$doCreate$iv = this;
        boolean $i$f$doCreate = false;
        ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
        boolean $i$f$withValidComps = false;
        int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
        int n = size$iv$iv - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
            throw new IllegalArgumentException(string.toString());
        }
        float[] it$iv = components;
        boolean bl = false;
        float f2 = components[0];
        float f3 = components[1];
        float f4 = components[2];
        int n3 = 3;
        float[] fArray = components;
        if (n3 < fArray.length) {
            f = fArray[n3];
        } else {
            int n4 = n3;
            float f5 = f4;
            float f6 = f3;
            float f7 = f2;
            boolean bl2 = false;
            float f8 = 1.0f;
            f2 = f7;
            f3 = f6;
            f4 = f5;
            f = f8;
        }
        float f9 = f;
        float f10 = f4;
        float f11 = f3;
        float p0 = f2;
        boolean bl3 = false;
        return (LCHab)((Color)this.invoke(p0, (float)p1, (float)p2, (float)p3));
    }

    @NotNull
    public String toString() {
        return "LCHabColorSpace(" + this.getWhitePoint() + ')';
    }

    @Override
    @NotNull
    public LCHab invoke(float l, float c, float h, float alpha) {
        return new LCHab(l, c, h, alpha, this);
    }

    public int hashCode() {
        return this.getWhitePoint().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof LCHabColorSpace && Intrinsics.areEqual(this.getWhitePoint(), ((LCHabColorSpace)other).getWhitePoint());
    }

    @NotNull
    public final WhitePoint component1() {
        return this.whitePoint;
    }

    @NotNull
    public final LCHabColorSpaceImpl copy(@NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter(whitePoint, "whitePoint");
        return new LCHabColorSpaceImpl(whitePoint);
    }

    public static /* synthetic */ LCHabColorSpaceImpl copy$default(LCHabColorSpaceImpl lCHabColorSpaceImpl, WhitePoint whitePoint, int n, Object object) {
        if ((n & 1) != 0) {
            whitePoint = lCHabColorSpaceImpl.whitePoint;
        }
        return lCHabColorSpaceImpl.copy(whitePoint);
    }

    @Override
    @NotNull
    public LCHab invoke(@NotNull Number l, @NotNull Number c, @NotNull Number h, @NotNull Number alpha) {
        return LCHabColorSpace.DefaultImpls.invoke(this, l, c, h, alpha);
    }
}

