;; LaTeXinfo support for European languages.

(defun latexinfo-format-scan ()
  ;; LaTeX sometimes uses \\ to force a new-line
  (goto-char (point-min))
  (replace-regexp "\\\\\\\\$" "")
  ;; This is the same as latexinfo-format-scan, except for 
  (goto-char (point-min))
  (latexinfo-europe-doublequotes)
  ;; And don't convert left and right quotes to typewriter font quotes.
  ;;  (goto-char (point-min))
  ;;  (while (search-forward "``" nil t)
  ;;    (replace-match "\""))
  ;;  (goto-char (point-min))
  ;;  (while (search-forward "''" nil t)
  ;;    (replace-match "\""))
  ;; Scan for \-commands.
  (goto-char (point-min))
  (while (search-forward "\\" nil t)
    (if (looking-at "[@{}'` *%]")
	;; Handle a few special \-followed-by-one-char commands.
	(if (= (following-char) ?*)
	    ;; \* has no effect, since we are not filling.
	    (delete-region (1- (point)) (1+ (point)))
	  ;; The other characters are simply quoted.  Delete the \.
	  (delete-char -1)
	  (forward-char 1))
      ;; \ is followed by a command-word; find the end of the word.
      (setq latexinfo-command-start (1- (point)))
      (if (= (char-syntax (following-char)) ?w)
	  (forward-word 1)
	(forward-char 1))
      (setq latexinfo-command-end (point))
      ;; Call the handler for this command.
      (setq latexinfo-command-name
	    (intern (buffer-substring (1+ latexinfo-command-start)
				      latexinfo-command-end)))
      (let ((cmd (get latexinfo-command-name 'latexinfo-format)))
	(if cmd (funcall cmd)
	  (latexinfo-unsupported)))))
  (cond (latexinfo-stack
	 (goto-char (nth 2 (car latexinfo-stack)))
	 (error "Unterminated \begin{%s}" (car (car latexinfo-stack))))))

(defun latexinfo-europe-doublequotes ()
  (while (search-forward "\"" nil t)
    (forward-char -2)
    (if (eq (following-char) ?\\)
	;; Ignore \"
	(forward-char 2)
      (progn
	(forward-char 2)
	(let ((next-char (following-char))
	      (here (point)))
	  (cond
	   ;; Just junk these cases:
	   ;; "| to separate ligatures.
	   ;; "- like \-, but allowing hyphenation in the rest of
	   ;;                    the word.
	   ;; "" like "-, but producing no hyphen sign.
	   ((memq next-char '(?\| ?\- ?\"))
	    (delete-region (- here 1) (+ here 1)))
	   ;; Just ignore these cases:
	   ;; "ck for ck to be hyphenated as k-k.
	   ;; "ff for ff to be hyphenated as ff-f, also for certain
	   ;;                    other consonants.
	   ((memq next-char '(?c ?f ?l ?m ?n ?p ?t ?C ?F ?L ?M ?N ?P ?T))
	    ;; There should be better testing here.
	    (delete-char -1))
	   ;; "a for Umlaut-a (like \"a), also for all other vowels.
	   ;; For these two, add an e.
	   ((memq next-char '(?a ?o ?u))
	    (delete-char -1)
	    (forward-char 1)
	    (insert "e"))
	   ((memq next-char '(?A ?O ?U))
	    (delete-char -1)
	    (forward-char 1)
	    (insert "E"))
	   ((memq next-char '(?e ?i ?E ?I))
	    (delete-char -1))
	   ;; s for sharp s  (like \ss{})
	   ((eq next-char ?s)
	    (delete-region (- here 1) (+ here 1))
	    (insert "ss"))
	   ;; ` or \glqq for german left  double quotes  (similar to ,,)
	   ((eq next-char ?\`)
	    (delete-region (- here 1) (+ here 1))
	    (insert "\\glqq "))
	   ;; ' or \grqq for german right double quotes  (similar to ``)
	   ((eq next-char ?\')
	    (delete-region (- here 1) (+ here 1))
	    (insert "\\grqq "))
	   ;; < or \flqq for french left  double quotes  (similar to <<)
	   ((eq next-char ?\<)
	    (delete-region (- here 1) (+ here 1))
	    (insert "\\flqq "))
	   ;; > or \frqq for french right double quotes  (similar to >>)
	   ((eq next-char ?\>)
	    (delete-region (- here 1) (+ here 1))
	    (insert "\\frqq "))
	   ;; Ignore all other cases
	   ))))
    ))


;;; "` or \glqq        for german left  double quotes  (similar to ,,)
(put 'glqq 'latexinfo-format 'latexinfo-format-glqq)
(defun latexinfo-format-glqq ()
  (latexinfo-parse-noarg)
  (insert ",,"))

;;; "' or \grqq        for german right double quotes  (similar to ``)
(put 'grqq 'latexinfo-format 'latexinfo-format-grqq)
(defun latexinfo-format-grqq ()
  (latexinfo-parse-noarg)
  (insert "``"))

;;;       \glq         for german left  single quotes  (similar to , )
(put 'glq 'latexinfo-format 'latexinfo-format-glq)
(defun latexinfo-format-glq ()
  (latexinfo-parse-noarg)
  (insert ","))

;;;       \grq         for german right single quotes  (similar to ` )
(put 'grq 'latexinfo-format 'latexinfo-format-grq)
(defun latexinfo-format-grq ()
  (latexinfo-parse-noarg)
  (insert "`"))

;;; "< or \flqq        for french left  double quotes  (similar to <<)
(put 'flqq 'latexinfo-format 'latexinfo-format-flqq)
(defun latexinfo-format-flqq ()
  (latexinfo-parse-noarg)
  (insert "<<"))

;;; "> or \frqq        for french right double quotes  (similar to >>)
(put 'frqq 'latexinfo-format 'latexinfo-format-frqq)
(defun latexinfo-format-frqq ()
  (latexinfo-parse-noarg)
  (insert ">>"))

;;;       \flq         for french left  single quotes  (similar to < )
(put 'flq 'latexinfo-format 'latexinfo-format-flq)
(defun latexinfo-format-flq ()
  (latexinfo-parse-noarg)
  (insert "<"))

;;;       \frq         for french right single quotes  (similar to > )
(put 'frq 'latexinfo-format 'latexinfo-format-frq)
(defun latexinfo-format-frq ()
  (latexinfo-parse-noarg)
  (insert ">"))

;;; \ss
(put 'ss 'latexinfo-format 'latexinfo-format-ss)
(defun latexinfo-format-ss ()
  (latexinfo-parse-noarg)
  (insert "ss"))

;;; \dq                for the original quotes character (")
(put 'dq 'latexinfo-format 'latexinfo-format-dq)
(defun latexinfo-format-dq ()
  (latexinfo-parse-noarg)
  (insert "\""))


;;; \setlanguage{n}	to switch to the language specified by n
(put 'setlanguage 'latexinfo-format 'latexinfo-format-noop)

;;; \originalTeX       to restore everything to the original settings
(put 'originalTeX 'latexinfo-format 'latexinfo-format-originalTeX)
;; Unfortunately, this will not work yet in the info file.
(defun latexinfo-format-originalTeX ()
  (latexinfo-format-noop)
  (setq latexinfo-germanTeX nil))


;;; \germanTeX         to re-activate the german settings.
(put 'germanTeX 'latexinfo-format 'latexinfo-format-germanTeX)
;; Unfortunately, this is assumed throughout the info file.
(defun latexinfo-format-germanTeX ()
  (latexinfo-format-noop)
  (setq latexinfo-germanTeX t))
  
(setq latexinfo-germanTeX t)
