;;(if (null (getenv "LATEXINFO"))
;;  (error "You must define the environment variable LATEXINFO first."))

(defun compile-if-necessary (file)
  (let ((filename (expand-file-name file)))
    (cond ((not (file-exists-p filename))
	   (error "File not found: %s" filename))
	  ((not (file-exists-p (concat filename "c")))
	   (byte-compile-file filename))
	  ((file-newer-than-file-p filename (concat filename "c"))
	   (byte-compile-file filename))
	  (t
	   (message "%s is up to date." filename)))
    )
  )

;;; LaTeXinfo
(setq load-path 
      (cons (setq latexinfo-formats-directory
		  (file-name-as-directory "ELISP"))
	    load-path))

(load-file  "LATEXINFO/.latexinfo")
(compile-if-necessary "PROGRAM.el")
(load-file "PROGRAM.elc")
(mapcar 'compile-if-necessary (directory-files "ELISP" t ".*.el$"))
(find-file  "MANUAL.tex")
(latexinfo-format-buffer t)
(save-some-buffers t)
(kill-emacs 0)
