#!/bin/bash
#
# 
# Installation script for Omega for Malayalam
#
# Alex A.J. <indicTeX@gmail.com>
#
#
#
#
#
echo -e "\nInstallation script for Omega/Aleph for Malayalam"
echo -e "Alex A.J. <indicTeX@gmail.com>\n"
echo -e "Starting installation...\n"


echo -e "TEXMF root directory (Press <ENTER> if the default is ok)"
echo -e "(The default should be ok for most Linux systems)"
echo -e "Caution: DO NOT type / at the end of directory name\n"
echo -e "(/usr/share/texmf): \c"
read texdir
if [ "$texdir" = "" ]
then
   texdir="/usr/share/texmf"
fi

echo -e "\nInstalling packages...\n"

# The directories

mkdir -p $texdir/doc/indic/malayalam/omega
mkdir -p $texdir/tex/lambda/malayalam
mkdir -p $texdir/omega/otp/malayalam
mkdir -p $texdir/omega/ocp/malayalam
mkdir -p $texdir/fonts/map/dvips/malayalam
mkdir -p $texdir/fonts/type1/malayalam/keli
mkdir -p $texdir/fonts/type1/malayalam/rachana
mkdir -p $texdir/fonts/tfm/malayalam/keli
mkdir -p $texdir/fonts/tfm/malayalam/rachana
mkdir -p $texdir/fonts/tfm/malayalam/ism

# The files

cp -f ./fonts/keli/*.pfb $texdir/fonts/type1/malayalam/keli
cp -f ./fonts/keli/*.tfm $texdir/fonts/tfm/malayalam/keli
cp -f ./fonts/rachana/*.pfb $texdir/fonts/type1/malayalam/rachana
cp -f ./fonts/rachana/*.tfm $texdir/fonts/tfm/malayalam/rachana
cp -f ./fonts/ism/*.tfm $texdir/fonts/tfm/malayalam/ism
cp -f ./fonts/*.map $texdir/fonts/map/dvips/malayalam
cp -f ./omega/*.sty $texdir/tex/lambda/malayalam
cp -f ./omega/*.fd $texdir/tex/lambda/malayalam
cp -f ./otp/*.otp $texdir/omega/otp/malayalam
cp -f ./otp/*.ocp $texdir/omega/ocp/malayalam
cp -f ./doc/* $texdir/doc/indic/malayalam/omega


# Post installation commands

texhash
updmap-sys --enable Map malayalam.map

echo -e "\n\nInstallation of Omega for Malayalam completed successfully.\n"
echo -e "Documentation can be found in $texdir/doc/indic/malayalam/omega directory\n"
echo -e "Some examples are provided in the examples subdirectory of the untarred package\n"



#
#End of file
