/*

This file is public domain.

From an MS page `TN020: ID Naming and Numbering Conventions':

Preﬁx          Resource type           Valid range
IDR_           multiple                1 through 0x6FFF (28671)
IDD_           dialog templates        1 through 0x6FFF
IDC_,IDI_,IDB_ cursors, icons, bitmaps 1 through 0x6FFF
IDS_, IDP_     general strings         1 through 0x7FFF (32767)
ID_            commands                0x8000 through 0xDFFF (32768 - 57343)
IDC_           controls                8 through 0xDFFF


- 0x8000 - 0xdfff (32768 - 57343) for commands / 'menu prompts for commands'
- 0x0101 - 0x6fff (00257 - 28671) for other items
`real' resources up to 0x7fff
0 should remain unused, 1-7 used by M$
check winuser.h for additional predefined resource numbers
according to the list above, IDC_ is both for controls and for cursors

From
http://stackoverflow.com/questions/19174690/idd-about-undeclared-identifier/ :

The windows headers define generic certain resource IDs (IDOK,
IDCANCEL, IDC_STATIC, etc) but for anything else you'll need to add
your own symbol. The values don't really matter - any number up to
65534 is ok as long as it doesn't clash with any other ID in use in
the same "scope" (e.g. two controls in the one dialog should have
different IDs, but you can re-use the same ID in another dialog).
*/

#define IDC_STATIC -1

// icon
#define IDI_TL 101
#define IDI_SELECT 102
#define IDI_DEFLT 103
// dialogs
#define IDD_TEXT 110
// controls
#define ID_RUN 40004
#define ID_QUIT 40005
#define ID_DO 40006
#define ID_DONT 40007
#define ID_TEXT 40008
#define ID_CUSTOM 40009
// #define ID_CLOSE_EDS 40010
#define ID_SPLASH 40011

// start of automatically generated IDs for menu entries and controls:
#define ID_FIRST_CONTROL 40100
// for other automatically numbered child windows (used?)
#define ID_FIRST_CHILD 1000
// for the editors/options dialog:
#define ID_FIRST_EDS_CHILD 500
