Program Afm2Tex_G;      {  Version 1.5   -- 12. April 1994}
                           { fuer ghostscript's getafm }
Uses DOS;

{ (c) 1994 Markus Neteler    Hannover
  email: neteler@laum.uni-hannover.de

PROGRAMMBESCHREIBUNG:

 Afm2TeXG stellt afm-Dateien in die richtige Reihenfolge fuer TeX um und
 speichert die neuen Informationen in *.aft.
 Anschlieend kann Afm2Tfm angewendet werden, fuer TeX ist damit keine
 neue Encodierung der Zeichen noetig. D.h., die Schriften koennen wie
 die computer-modern-Schriften verwendet werden.

ZU AENDERNDE BUCHSTABEN IN ZEICHENSATZ.AFM :
 fuer ghostscript's getafm!
 Bei anderen Encodierungen (Adobe(tm) und Corel's Wfnboss(tm)) bitte
 afm2texA.exe benutzten.
 Um die vorliegende Encodierung zu ueberpruefen, kann die Datei <font>.afm
 angesehen werden. Dort muss das Zeichen "grave" der Nummer C 193 zugeordnet
 sein: "C 193 ... grave ".


  Postscript (sort.)   TeX        myNo.    | myNo.     PS      TeX (sort.)
   (Org-number)       (for .aft)           |                  No. (for .aft)
-------------------------------------------|--------------------------------
34   quotedbl          125        22       |   1       fi            12
161  exclamdown         60        17       |   2       fl            13
170  quotedblleft       92        19       |   3       dotlessi      16
174  fi                 12         1       |   4       grave         18
175  fl                 13         2       |   5       acute         19
177  endash            123        20       |   6       breve         21
186  quotedblright      34        16       |   7       ring          23
191  questiondown       62        18       |   8       circumflex    24
193  grave              18         4       |   9       germandbls    25
194  acute              19         5       |  10       ae            26
195  circumflex         24         8       |  11       oe            27
196  tilde             126        23       |  12       oslash        28
198  breve              21         6       |  13       AE            29
200  dieresis          127        24       |  14       OE            30
202  ring               23         7       |  15       Oslash        31
208  emdash            124        21       |  16       quotedblright 34
225  AE                 29        13       |  17       exclamdown    60
233  Oslash             31        15       |  18       questiondown  62
234  OE                 30        14       |  19       quotedblleft  92
241  ae                 26        10       |  20       endash        123
245  dotlessi           16         3       |  21       emdash        124
249  oslash             28        12       |  22       quotedbl      125
250  oe                 27        11       |  23       tilde         126
251  germandbls         25         9       |  24       dieresis      127
                                         (maxletters)


 Change const. maxletters, if adding letters!
 Add numbers to Dummy-Table!
 Change writing-out part of program!
------------------------------------------------------------------------

ACHTUNG: Es muessen echte "carriage returns" an den Zeilenenden der
         afm-Datei stehen!
}
const maxletters =24;

Type Str255=String[255];
     Str25 =String[25];

var f,p             : Text;
    PostscriptAlt   : Array[0..30] of Str255;
    PostscriptNeu   : Array[0..30] of Str255;
    Zeile1,Dummy    : Str255;
    DatName,DatName2: String[12];
    i,k             : Integer;
    PS              : Array[1..30] of Integer;
    TeX             : Array[1..30] of String[3];
    flag            : Boolean;
    Fehler          : Byte;

Procedure Analyse(Var Kette:Str255);
Var Zeichenkette : Str255;
    j            : Integer;

Begin
 Zeichenkette:='';
 j:=1;
 While not (Kette[j] in ['-','0'..'9']) do j:=j+1;

  { C -1 ; WX ... -> C 00 ; WX ... : unschaedlich machen}
 If (Kette[j]='-') then Begin
                         Kette[j]:='0';
                         Kette[j+1]:='0'
                        End;

 While not (Kette[j]=' ') Do Begin
    Zeichenkette:=Zeichenkette + Kette[j];
    j:=j+1;
 End;
 Kette:=Zeichenkette;
End;

function IToS(i: Longint): string;
{ Convert any Integer type to a string }
var s: string[11];
begin
  Str(i, s);
  IToS := s;
end;

function Datum:Str25;
const days : array [0..6] of String[9] =
             ('sunday','monday','tuesday',
              'wednesday','thursday','friday',
              'saturday');
var
  y, m, d, dow : Word;
begin
  GetDate(y,m,d,dow);
  Datum:= days[dow]+', '+ ItoS(d)+ '.'+ ItoS(m)+ '.'+ ItoS(y);
end;

Function Zeit:Str25;
 var h, m, s, hund : Word;

   function LeadingZero(w : Word) : String;
   var  s : String;
   begin
     Str(w:0,s);
     if Length(s) = 1 then
        s := '0' + s;
     LeadingZero := s;
   end;
begin
  GetTime(h,m,s,hund);
  Zeit:=LeadingZero(h)+':'+LeadingZero(m)+':'+LeadingZero(s)+'.'+LeadingZero(hund);
end;

Procedure Analyse2(Var Kette:Str255);
Var Zeichenkette : Str255;
    j            : Integer;
Begin
 Zeichenkette:='C ';
 j:=1;
 While not (Kette[j] in ['0'..'9']) do j:=j+1;
 Zeichenkette:=Zeichenkette+TeX[i];
 While not (Kette[j]=' ') Do j:=j+1;
 While not (Length(Kette)=j+1) Do Begin
    Zeichenkette:=Zeichenkette + Kette[j];
    j:=j+1;
 End;
 Kette:=Zeichenkette+' ;';
End;


Begin       {main program}
 For i:=1 to 30 Do Begin
  PS [i]:=0;
  TeX[i]:='';
 End;
 For i:=0 to 30 Do PostscriptAlt[i]:='';
 For i:=0 to 30 Do PostscriptNeu[i]:='';

 {Tex-numbers from TeX-sorted}
  TeX[1 ]:='12';
  TeX[2 ]:='13';
  TeX[3 ]:='16';
  TeX[4 ]:='18';
  TeX[5 ]:='19';
  TeX[6 ]:='21';
  TeX[7 ]:='23';
  TeX[8 ]:='24';
  TeX[9 ]:='25';
  TeX[10]:='26';
  TeX[11]:='27';
  TeX[12]:='28';
  TeX[13]:='29';
  TeX[14]:='30';
  TeX[15]:='31';
  TeX[16]:='34';
  TeX[17]:='60';
  TeX[18]:='62';
  TeX[19]:='92';
  TeX[20]:='123';
  TeX[21]:='124';
  TeX[22]:='125';
  TeX[23]:='126';
  TeX[24]:='127';

{Standard-Adobe-encoding }
{myNo-numbers from Postscript-sorted}
 PS[1 ]:=22;
 PS[2 ]:=17;
 PS[3 ]:=19;
 PS[4 ]:= 1;
 PS[5 ]:= 2;
 PS[6 ]:=20;
 PS[7 ]:=16;
 PS[8 ]:=18;
 PS[9 ]:= 4;
 PS[10]:= 5;
 PS[11]:= 8;
 PS[12]:=23;
 PS[13]:= 6;
 PS[14]:=24;
 PS[15]:= 7;
 PS[16]:=21;
 PS[17]:=13;
 PS[18]:=15;
 PS[19]:=14;
 PS[20]:=10;
 PS[21]:= 3;
 PS[22]:=12;
 PS[23]:=11;
 PS[24]:= 9;

 Writeln('     --* Conversion of .afm fontdefinitions to TeX      -  V1.5  1994 *--');
 Writeln('                 for the use with afm2tfm                (c) M. Neteler');
 Writeln;
 Writeln('              Encoded for postscript-fonts made by ');
 Writeln('                     ghostscript`s getafm ');

 Writeln;
 Writeln('          ** check font.afm for "C 193 ... grave " **');
 Writeln('                 else use afm2texA.exe');
 Writeln;
 If Paramcount=0 Then Begin
     Write(' Name of font (with suffix .afm): ');
     Readln(Datname);
    End
 Else Datname:=Paramstr(1);

 DatName2:='';
 i:=1;
 While not ((DatName[i] ='.') or (i=Length(DatName)+1)) do Begin
  DatName2:=DatName2+Datname[i];
  i:=i+1
 End;
 If Datname2='' Then Halt;
 Datname:=Datname2;
 {$i-}
 Assign(f,DatName+'.afm');
 Reset(f);
 Writeln;
 Writeln;
 Writeln;
 Fehler:=IOResult;
 IF Fehler=2 Then Begin Writeln(' Problem! '+DatName+'.afm not found...'); Halt end;
 IF Fehler=3 Then Begin Writeln(' Problem! Path of '+DatName+'.afm not found...'); Halt End;
 Assign(p,Datname2+'.aft');
 Rewrite(p);
 Fehler:=IOResult;
 IF Fehler=2 Then Begin Writeln(' Problem! '+DatName+'.afm not found...'); Halt end;
 IF Fehler=3 Then Begin Writeln(' Problem! Path of '+DatName+'.afm not found...'); Halt End;
 {$i+}

 Write('Conversion in process ');
 flag:=false;

 i:=1;
 While (not (EOF(f) or flag)) and (i<3) Do Begin
  Readln(f,Zeile1);
  Write('.');
  If (Zeile1[1]='C') and (Zeile1[2]=' ') Then flag:=True
   Else Writeln(p,Zeile1);
  I:=i+1;
 End; {while}

 Writeln(p,'Comment Converted with afm2teX-G  to TeX  at ',Datum,' -- ',Zeit);

 While not (EOF(f) or flag) Do Begin
  Readln(f,Zeile1);
  Write('.');
  If (Zeile1[1]='C') and (Zeile1[2]=' ') Then flag:=True
   Else Writeln(p,Zeile1);
 End; {while}

{Zeichendefinition beginnt}
 i:=1;
 k:=1;
 While not EOF(f) DO Begin
  Dummy:=Zeile1;
  Analyse(Dummy);

 {Postscript- numbers original:}
  If (Dummy ='34') or (Dummy='161') or (Dummy='170') or (Dummy='174') or
     (Dummy='175') or (Dummy='177') or (Dummy='186') or (Dummy='191') or
     (Dummy='193') or (Dummy='194') or (Dummy='195') or
     (Dummy='196') or (Dummy='198') or (Dummy='200') or
     (Dummy='202') or (Dummy='208') or (Dummy='225') or (Dummy='233') or
     (Dummy='234') or (Dummy='241') or (Dummy='245') or (Dummy='249') or
     (Dummy='250') or (Dummy='251')
    Then Begin
      PostscriptAlt[i]:=Zeile1;
      i:=i+1 ;
    End; {if}
  Readln(f,Zeile1);
 End; {while}
 Close(f);

 {umkopieren}
 For i:=1 to maxletters do
  PostscriptNeu[PS[i]]:=PostscriptAlt[i];

 {Charakternummern aendern}
 For i:=1 to maxletters do
  If PostscriptNeu[i]<>'' Then Analyse2(PostscriptNeu[i]);

  {und noch einmal lesen}
 Assign(f,DatName+'.afm');
 Reset(f);

 flag:=false;
 While not (EOF(f) or flag) Do Begin
  Readln(f,Zeile1);
  Write('.'); {screen}
  If (Zeile1[1]='C') and (Zeile1[2]=' ') Then flag:=True  {definition found}
 End; {while}

 {-----------------------------------------------------------------
  ------ start writing of characters ------------------------------
    change here also, if you add characters}

{write beginning }  {i=myNo-right column (Tex sorted)  }
 For i:=1 to 15 do  {to Oslash}
  If PostscriptNeu[i]<>'' Then Writeln(p,PostscriptNeu[i]);

 readln (f,Zeile1); {write : 32 space}
 writeln(p,Zeile1);
 readln (f,Zeile1); {write : 33 exclam}
 writeln(p,Zeile1);

 If PostscriptNeu[16]<>'' Then Writeln(p,PostscriptNeu[16]); { quotedblright}

 For k:=35 to 59  do begin   {k=Postscript-number original: C 34 number ,...}
  readln (f,Zeile1);    {till semicolon}
  writeln(p,Zeile1);
 end;

 readln(f,Zeile1);  {60 not : less}
 If PostscriptNeu[17]<>'' Then Writeln(p,PostscriptNeu[17]); {exclamdown}

  readln (f,Zeile1); {write : 61 equal}
  writeln(p,Zeile1);

 readln(f,Zeile1);  {62 not : greater}
 If PostscriptNeu[18]<>'' Then Writeln(p,PostscriptNeu[18]); {questiondown}

 For k:=63 to 91  do begin {write}
  readln (f,Zeile1);
  writeln(p,Zeile1);
 end;

  readln(f,Zeile1);  {92 not:  backslash }
  If PostscriptNeu[19]<>'' Then Writeln(p,PostscriptNeu[19]); {quotedblleft}

  readln (f,Zeile1); {93 schreiben: bracketright}
  writeln(p,Zeile1);

  readln(f,Zeile1);  {94 schreiben: asciicircum }
  writeln(p,Zeile1);

  For k:=95 to 122  do begin
  readln (f,Zeile1);
  writeln(p,Zeile1);
 end;

  For i:=20 to maxletters  do   {Rest of converted postscript}
  If PostscriptNeu[i]<>'' Then Writeln(p,PostscriptNeu[i]);

 {den Rest Kerning, etc.}
  While not EOF(f) Do Begin
  Readln(f,Zeile1);
  Write('.');
  If (Zeile1[1]<>'C') and (Zeile1[2]<>' ') Then Writeln(p,Zeile1);
 End; {while}
  Writeln;
  Writeln('   Ready .');
  Writeln;
  Writeln('   Now convert ',Datname,'.aft with afm2tfm like');
  Writeln;
  Writeln('          afm2tfm ',Datname,'.aft');
  Writeln;
  Writeln('   to get the TeX-encoded tfm-file. Convert the Postscript-font');
  Writeln('   with ps2mf. Now you can use the font like the standard');
  Writeln('   computer-modern fonts (cm-encoding-scheme).');
  Writeln;
  Writeln('   Have fun!');
  Close(f);
  Close(p);

End.



