## newbuild.pl							-*- Perl -*-
## Copyright (C) 1997 Christian Schenk
## Time-stamp: "97/07/29 21:10:31 mik"
## Author: Christian Schenk <cs@ronin.in-berlin.de>

require "newgetopt.pl";
use Cwd;

&main;
exit 0;

sub help

{
  print "Usage: newbuild [OPTIONS]\n\n";
  print "  --help            display this help text end exit\n";
  print "  --final           \n";
  print "  --beta            \n";
  print "  --alpha           \n";
  print "  --private         make a private build\n";
}

sub make_version_h

{
  $version_h_filename = $miktexsrcdir . "/lib/version.h";
  open VERSION_H, ">$version_h_filename";
  print VERSION_H "/* Made by newbuild.pl; DO NOT EDIT !!!   -*- C -*- */\n";
  print VERSION_H "#ifndef MIKTEX_PRODUCTNAME_STR\n";
  print VERSION_H "#define MIKTEX_PRODUCTNAME_STR \"MiKTeX\"\n";
  print VERSION_H "#define MIKTEX_COMPANYNAME_STR \"Christian Schenk\"\n";
  print VERSION_H "#define MIKTEX_BUILD_COMMENT_STR \"Build no. $build_number of $build_date_str; by $builder_name_str\"\n";
  print VERSION_H "#define MIKTEX_BUILD_DATE $build_date\n";
  print VERSION_H "#define MIKTEX_BUILDERNAME_STR \"$builder_name_str\"\n";
  print VERSION_H "#define MIKTEX_PRIVATEBUILD_STR \"Built by $builder_name_str\"\n";
  print VERSION_H "#ifndef MIKTEX_LEGALCOPYRIGHT_STR\n";
  print VERSION_H "#define MIKTEX_LEGALCOPYRIGHT_STR \"Copyright \251 1991-1997 Christian Schenk\"\n";
  print VERSION_H "#endif\n";
  print VERSION_H "#define MIKTEX_LEGALTRADEMARKS_STR \"\"\n";
  print VERSION_H "#define MIKTEX_MAJOR_VERSION $major_version_number\n";
  print VERSION_H "#define MIKTEX_MINOR_VERSION $minor_version_number\n";
  print VERSION_H "#define MIKTEX_BUILD_NUMBER $build_number\n";
  print VERSION_H "#define MIKTEX_MAJOR_VERSION_STR \"$major_version_number\"\n";
  print VERSION_H "#define MIKTEX_MINOR_VERSION_STR \"$minor_version_number\"\n";
  print VERSION_H "#define MIKTEX_BUILD_NUMBER_STR \"$build_number\"\n";
  print VERSION_H "#define MIKTEX_RELEASE_STATE $state\n";
  print VERSION_H "#define MIKTEX_ALPHA_NUMBER $alpha_number\n";
  print VERSION_H "#define MIKTEX_BETA_NUMBER $beta_number\n";
  print VERSION_H "#define MIKTEX_PATCH_NUMBER $patch_number\n";
  print VERSION_H "#define MIKTEX_PATCH_NUMBER_STR \"$patch_number_str\"\n";
  print VERSION_H "#define MIKTEX_BUILD_NUMBER $build_number\n";
  if ($state == 0)
    {
      $version_string = "$major_version_number.$minor_version_number$patch_number_str";
    }
  elsif ($state == 1)
    {
      $version_string = "$major_version_number.$minor_version_number beta $beta_number";
    }
  elsif ($state == 2)
    {
      $version_string = "$major_version_number.$minor_version_number alpha $alpha_number";
    }
  elsif ($state == 3)
    {
      $version_string = "$major_version_number.$minor_version_number $builder_name_str $build_number";
    }

  print VERSION_H "#define MIKTEX_PRODUCTVERSION_STR \"$version_string\"\n";
  print VERSION_H "#endif\n";
  close VERSION_H;
}

sub main

{
  unless (&NGetOpt ("help", "private", "alpha", "beta", "final"))
    {
      print STDERR "Try `newbuild --help'";
      exit 1;
    }
  if ($opt_help)
    {
      help;
      exit 0;
    }
  ($ss,$mm,$hh,$mday,$mon,$year) = localtime;
  $timestamp = (sprintf "%02d/%02d/%02d %02d:%02d:%02d %s",
		$year, $mon+1, $mday, $hh, $mm, $ss, $ENV{"USERNAME"});
  $builder_name_str = $ENV{"USERNAME"};
  $new_state = -1;
  $new_state = 3 if ($opt_private);
  $new_state = 2 if ($opt_alpha);
  $new_state = 1 if ($opt_beta);
  $new_state = 0 if ($opt_final);
  $miktexsrcdir = cwd ();
  $version_filename = $miktexsrcdir . "/miktex.inc";
  die "$version_filename does not exist"
    unless (-e $version_filename);
  open VERSION, $version_filename;
  open TMPFILE, ">xxx";
  $state = -1;
  $last_state = -1;
  $distribute = ($new_state >= 0);
  while (<VERSION>)
    {
      if (/^state = ([0123])/)
	{
	  $old_state = $state = $1;
	  $state = $new_state if ($new_state >= 0);
	  print TMPFILE "state = $state\n";
	}
      elsif (/^alpha_number = ([0-9]+)/)
	{
	  $alpha_number = $1;
	  if ($distribute)
	    {
	      if ($state == 2)
		{
		  $alpha_number++;
		}
	    }
	  print TMPFILE "alpha_number = $alpha_number\n";
	}
      elsif (/^beta_number = ([0-9]+)/)
	{
	  $beta_number = $1;
	  if ($distribute)
	    {
	      if ($state == 1)
		{
		  $beta_number++;
		}
	    }
	  print TMPFILE "beta_number = $beta_number\n";
	}
      elsif (/^(build_number = )([0-9]+)/)
	{
	  $build_number = $2 + 1;
	  print TMPFILE $1, $build_number, "\n";
	}
      elsif (/^build_date = /)
	{
	  $build_date = time ();
	  print TMPFILE $&, $build_date, "\n";
	}
      elsif (/^build_date_str = /)
	{
	  $build_date_str = localtime ();
	  print TMPFILE $&, $build_date_str . "\n";
	}
      elsif (/^miktexsrcdir = /)
	{
	  print TMPFILE $&, $miktexsrcdir . "\n";
	}
      else
	{
	  if (/^major_version_number = ([0-9]+)/)
	    {
	      $major_version_number = $1;
	    }
	  elsif (/^minor_version_number = ([0-9]+)/)
	    {
	      $minor_version_number = $1;
	    }
	  elsif (/^patch_number = ([0-9]+)/)
	    {
	      $patch_number = $1;
	    }
	  elsif (/^patch_number_str = ([a-z])/)
	    {
	      $patch_number_str = $1
	    }
	  else
	    {
	      s/Time-stamp:[ \t]+\"(.+)\"/Time-stamp: \"$timestamp\"/;
	    }
	  print TMPFILE;
	}
    }
  close VERSION;
  close TMPFILE;
  unlink ($version_filename);
  rename ("xxx", $version_filename);
  make_version_h ();
}
