// dviview.cpp : implementation of the CDviView class
// Time-stamp: "97/01/28 11:54:34 cschenk"
//
// Copyright (C) 1996, 97
//	Christian Schenk  <cschenk@berlin.snafu.de>
//
// This file is part of MiKTeX.
//
// MiKTeX is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// MiKTeX is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with MiKTeX; if not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "stdafx.h"
#include "yap.h"

#include "dvidoc.h"
#include "dviview.h"
#include "gotopage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDviView

IMPLEMENT_DYNCREATE(CDviView, CScrollView)

BEGIN_MESSAGE_MAP(CDviView, CScrollView)
	//{{AFX_MSG_MAP(CDviView)
	ON_COMMAND(ID_NEXT_PAGE, OnNextPage)
	ON_COMMAND(ID_PREV_PAGE, OnPrevPage)
	ON_COMMAND(ID_PAGE_DOWN, OnPageDown)
	ON_COMMAND(ID_PAGE_UP, OnPageUp)
	ON_COMMAND(ID_LINE_DOWN, OnLineDown)
	ON_COMMAND(ID_LINE_UP, OnLineUp)
	ON_COMMAND(ID_LINE_LEFT, OnLineLeft)
	ON_COMMAND(ID_LINE_RIGHT, OnLineRight)
	ON_COMMAND(ID_PAGE_LEFT, OnPageLeft)
	ON_COMMAND(ID_PAGE_RIGHT, OnPageRight)
	ON_COMMAND(ID_LAST_PAGE, OnLastPage)
	ON_COMMAND(ID_FIRST_PAGE, OnFirstPage)
	ON_COMMAND(ID_GOTO_PAGE, OnGotoPage)
	ON_COMMAND(ID_HOME, OnHome)
	ON_COMMAND(ID_END, OnEnd)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDviView construction/destruction

CDviView::CDviView ()

{
  // TODO: add construction code here

}

CDviView::~CDviView ()

{
}

/////////////////////////////////////////////////////////////////////////////
// CDviView drawing

void
CDviView::OnDraw (CDC* pDC)

{
  CDviDoc* pDoc = GetDocument ();
  ASSERT_VALID (pDoc);
  const dvi_page *page = pDoc->curdvipage ();
  if (page)
    {
#ifdef USE_DIB
      RGBQUAD argbq[] = {{ 0, 0, 0, 0 },
		         { 255, 255, 255, 0 }};
      PBITMAPINFO pbmi = (PBITMAPINFO) malloc (sizeof (BITMAPINFOHEADER)
					       + sizeof (RGBQUAD) * 2);	  
      memset (pbmi, 0, sizeof (BITMAPINFOHEADER) + sizeof (RGBQUAD) * 2);
      pbmi->bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
      pbmi->bmiHeader.biPlanes = 1;
      pbmi->bmiHeader.biBitCount = 1;
      pbmi->bmiHeader.biCompression = BI_RGB;
      pbmi->bmiHeader.biClrUsed = 0;
      memcpy (pbmi->bmiColors, argbq, sizeof(RGBQUAD) * 2);
#else
      CDC memDC;
      memDC.CreateCompatibleDC (pDC);
      memDC.SetMapMode (pDC->GetMapMode ());
#endif
      long zoom = pDoc->isprintcontext() ? 1 : pDoc->displayshrinkfactor;
      long xshift = pDoc->isprintcontext() ? pDoc->pagexshift : 0;
      long yshift = pDoc->isprintcontext() ? pDoc->pageyshift : 0;
      if (zoom > 1)
	{
#ifdef USE_HALFTONE
	  CPalette palette;
	  palette.CreateHalftonePalette (pDC);
	  pDC->SetStretchBltMode (HALFTONE);
	  CPalette *palp = pDC->SelectPalette (&palette, TRUE);
	  pDC->RealizePalette ();
#else
	  pDC->SetStretchBltMode (BLACKONWHITE);
#endif
	}
      for (dvi_integer i = 0; i < page->numofbitmaps (); i++)
	{
	  const dvi_bitmap &dvibm = page->getbitmap (i);
#ifdef USE_DIB
	  pbmi->bmiHeader.biWidth = dvibm.width;
	  pbmi->bmiHeader.biHeight = - dvibm.height;
	  ::StretchDIBits (pDC->m_hDC,
			   xshift + dvibm.x / zoom,
			   yshift + dvibm.y / zoom,
			   dvibm.width / zoom,
			   dvibm.height / zoom,
			   0,
			   0,
			   dvibm.width,
			   dvibm.height,
			   dvibm.bitmap,
			   pbmi,
			   DIB_RGB_COLORS,
			   SRCCOPY);
#else
	  BITMAP bminfo;
	  bminfo.bmType = 0;
	  bminfo.bmPlanes = 1;
	  bminfo.bmBitsPixel = 1;
	  CPoint dest;
	  CSize pagesize;
	  bminfo.bmBits = (void *) dvibm.bitmap;
	  bminfo.bmWidth = dvibm.width;
	  bminfo.bmHeight = dvibm.height;
	  bminfo.bmWidthBytes = ((dvibm.width + 15) / 16) * 2;
	  CBitmap bm;
	  bm.CreateBitmapIndirect (&bminfo);
	  CBitmap *oldbm = memDC.SelectObject (&bm);
	  if (zoom == 1)
	    pDC->BitBlt (dvibm.x,
			 dvibm.y,
			 dvibm.width,
			 dvibm.height,
			 &memDC, 0, 0,
			 SRCCOPY);
	  else
	    pDC->StretchBlt (dvibm.x / zoom,
			     dvibm.y / zoom,
			     dvibm.width / zoom,
			     dvibm.height / zoom,
			     &memDC, 0, 0,
			     dvibm.width,
			     dvibm.height,
			     SRCCOPY);
	  memDC.SelectObject (oldbm);
#endif
	}
#ifdef USE_DIB
      free (pbmi);
#endif
    }
}

void
CDviView::OnInitialUpdate ()

{
	CScrollView::OnInitialUpdate();
}

/////////////////////////////////////////////////////////////////////////////
// CDviView printing

BOOL
CDviView::OnPreparePrinting (CPrintInfo* pInfo)

{
    if (CDviDoc::printermode == "")
    {
      AfxMessageBox ("You must select a METAFONT mode for the printer!",
	MB_OK | MB_ICONEXCLAMATION);
      return (FALSE);
    }
  else if (CDviDoc::printerres == 0)
    {
     AfxMessageBox ("You must specify a printer resolution!",
	MB_OK | MB_ICONEXCLAMATION);
      return (FALSE);
    }
  else
    {
      CDviDoc *doc = GetDocument ();
      pInfo->m_nCurPage = doc->pageno () + 1;
      pInfo->SetMaxPage (doc->pagecount ());
      return DoPreparePrinting(pInfo);
    }
}

void
CDviView::OnBeginPrinting (CDC* /*pDC*/, CPrintInfo* /*pInfo*/)

{
  // TODO: add extra initialization before printing
}

void
CDviView::OnEndPrinting (CDC* /*pDC*/, CPrintInfo* /*pInfo*/)

{
  // TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CDviView diagnostics

#ifdef _DEBUG
void
CDviView::AssertValid () const

{
  CScrollView::AssertValid ();
}

void
CDviView::Dump (CDumpContext& dc) const

{
  CScrollView::Dump (dc);
}

CDviDoc *
CDviView::GetDocument () // non-debug version is inline

{
  ASSERT (m_pDocument->IsKindOf (RUNTIME_CLASS (CDviDoc)));
  return ((CDviDoc*) m_pDocument);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDviView message handlers

void
CDviView::OnUpdate (CView* pSender,
		    LPARAM lHint,
		    CObject* pHint) 
  
{
  CScrollView::OnUpdate (pSender, lHint, pHint);
  CDviDoc *doc = GetDocument ();
  const dvi_page *page = doc->curdvipage ();
  if (page)
    {
      int addx = 10;
      int addy = 10;
      dvi_pixel x, y, width, height;
      page->boundingbox (x, y, width, height);
      SetScrollSizes (MM_TEXT,
		      CSize ((width + x + addx) / doc->displayshrinkfactor,
			     (height + y + addy) / doc->displayshrinkfactor));
    }
}

void
CDviView::OnNextPage () 

{
  CDviDoc *doc = GetDocument ();
  doc->nextpage ();
  CSize sizeTotal;
  SetScrollSizes(MM_TEXT, doc->pagesize ());
  Invalidate ();
}

void
CDviView::OnPrevPage () 

{
  CDviDoc *doc = GetDocument ();
  doc->prevpage ();
  CSize sizeTotal;
  SetScrollSizes(MM_TEXT, doc->pagesize ());
  Invalidate ();
}

void
CDviView::OnPageDown () 

{
  OnScrollBy (CSize (0, m_pageDev.cy), TRUE);
  UpdateWindow ();
}

void
CDviView::OnPageUp () 

{
  OnScrollBy (CSize (0, -m_pageDev.cy), TRUE);
  UpdateWindow ();
}

void
CDviView::OnLineDown () 

{
  OnScrollBy (CSize (0, m_lineDev.cy), TRUE);
  UpdateWindow ();
}

void
CDviView::OnLineUp () 

{
  OnScrollBy (CSize (0, -m_lineDev.cy), TRUE);
  UpdateWindow ();
}

void
CDviView::OnLineLeft () 

{
  OnScrollBy (CSize (-m_lineDev.cx, 0), TRUE);
  UpdateWindow ();
}

void
CDviView::OnLineRight () 

{
  OnScrollBy (CSize (m_lineDev.cx, 0), TRUE);
  UpdateWindow ();
}

void
CDviView::OnPageLeft () 

{
  OnScrollBy (CSize (-m_pageDev.cx, 0), TRUE);
  UpdateWindow ();
}

void
CDviView::OnPageRight () 

{
  OnScrollBy (CSize (m_pageDev.cx, 0), TRUE);
  UpdateWindow ();
}

void CDviView::OnLastPage() 
{
	CDviDoc *doc = GetDocument ();
	doc->gotopage (10000);
	CSize sizeTotal;
	SetScrollSizes(MM_TEXT, doc->pagesize ());
	Invalidate ();
}

void CDviView::OnFirstPage() 
{
	CDviDoc *doc = GetDocument ();
	doc->gotopage (0);
	CSize sizeTotal;
	SetScrollSizes(MM_TEXT, doc->pagesize ());
	Invalidate ();
}

void
CDviView::OnPrint (CDC* pDC,
		   CPrintInfo* pInfo) 

{
  CDviDoc *doc = GetDocument ();
  int printerpagewidth = pDC->GetDeviceCaps (HORZRES);
  int printerpageheight = pDC->GetDeviceCaps (VERTRES);
  CSize dvipagesize = doc->pagesize ();
  if (doc->prepareprinting (pDC))
    {
      doc->switchcontext (1);
      doc->gotopage (pInfo->m_nCurPage - 1);
      CScrollView::OnPrint(pDC, pInfo);
      doc->switchcontext (0);
    }
}

void CDviView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	Invalidate ();
	CScrollView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

void CDviView::OnGotoPage() 
{
	CDviDoc *doc = GetDocument ();
	CGotoPage dlg (this);
	dlg.setpageno (doc->pageno ());
	if (dlg.DoModal () == IDOK)
		{
			UINT pageno = dlg.getpageno ();
			doc->gotopage (pageno);
			CSize sizeTotal;
			SetScrollSizes(MM_TEXT,
				doc->pagesize ());
			Invalidate ();
		}
}

void CDviView::OnHome() 
{
	ScrollToPosition (CPoint (0, 0));
}

void CDviView::OnEnd() 
{
	CSize size = GetTotalSize ();
	ScrollToPosition (CPoint (0, size.cy));	
}
