// Name of a group of files
[groupname]
/l50011/l

// This section contains extensions of files belonging to the group.
// If one extenstion belongs to more than one group, definitions from all the
// groups are applied
[extensions]
mp

// Appear in Add File Dialog as file types (number is a position in combobox list)
[filterindex]
3

// Associations for Windows
// Syntaxt:
//     extension=internal_name=windows_shell_name
[associations]
mp=TeXMetaPostFile.LEd=/l64000/l

// Access type to the files from the group
[access]
// level    = (0-readonly, 1-ask before edit, 2-fullaccess}
// question = {nicetext shown to ask the file should be edited}
// exec     = {file name to execute when a file is opened}
level=2

// Defines if the group of files is enabled by default
[default]
yes

// Some options
[options]
casesensitive=yes
usethesaurus=yes
spellchecking=yes

// Hilight commands
// Predefined groups:
// [hilight\keys]     - keywords
// [hilight\symbols]  - special symbols
// [hilight\types]    - types
// [hilight\comments] - comments
[hilight\MetaPostKeys]
addto
clip
cutdraw
draw
drawarrow
drawblarrow
fill
filldraw
interim
let
loggingall
newinternal
pickup
save
setbounds
shipout
show
showdependencies
showtoken
showvariable
special
tracingall
tracingnone
undraw
unfill
unfilldraw
boxit
boxjoin
bpath
buildcycle
circleit
dashpattern
decr
dotlabel
dotlabels
drawboxed
drawoptions
drawunboxed
fixpos
fixsize
incr
label
labels
max
min
pic
thelabel
z
begingroup
endgroup
btex
etex
of
str
curl
tension
controls
and
reflectedabout
rotatedaround
beginfig
endfig
enddef
def
vardef
expr
suffix
text
primary
secondary
tertiary
primarydef
secondarydef
tertiarydef
drawoptions
lft
rt
top
bot
ulft
urt
llft
lrt
pickup
randomseed
shipout
addto
also
contour
doublepath
withcolor
withpen
dashed
if
fi
else
elseif
endfor
for
forsuffixes
forever
upto
downto

charlist
extensible
fontdimen
headerbyte
kern
ligtable
boundarychar
chardp
charext
charht
charic
charwd
designsize
fontmaking
charexists

beginchar
blacker
capsule_def
change_width
define_blacker_pixels
define_corrected_pixels
defins_goog_x_pixels
define_horizontal_corrected_pixels
define_pixels
define_whole_blacker_pixels
define_whole_pixels
define_whole_vertical_blacker_pixels
define_whole_vertical_pixels
endchar
extra_beginchar
extra_endchar
extra_setup
font_coding_scheme
font_extra_space
font_identifier
font_normal_shrink
font_normal_space
font_normal_stretch
font_quad
font_size
font_slant
font_x_height
italcorr
labelfont
makebox
makegrid
maketicks
mode_def
mode_setup
o_correction
proofrule
proofrulethickness
rulepen
smode

cullit
currenttransform
gfcorners
grayfont
hround
imagerules
lowres_fix
nodisplays
notransforms
openit
proofoffset
screenchars
screenrule
screenstrokes
showit
slantfont
titlefont
unitpixel
vround

withweight
autorounding
chardx
chardy
fillin
granularity
hppp
proofing
smoothing
tracingedges
tracingpens
turningcheck
vppp
xoffset
yoffset

bluepart
btex
clip
color
dashed
etex
fontsize
greenpart
infont
linecap
linejoin
llcorner
lrcorner
miterlimit
mpxbreak
prologues
redpart
setbounds
tracinglostchars
truecorners
ulcorner
urcorner
verbatimtex
withcolor

ahangle
ahlength
background
bbox
bboxmargin
beginfig
beveled
black
blue
buildcycle
butt
center
cutafter
cutbefore
cuttings
dashpattern
defaultfont
defaultpen
defaultscale
dotlabel
dotlabels
drawarrow
drawdblarrow
drawoptions
endfig
evelny
extra_beginfig
extra_endfig
green
label
labeloffset
mitered
red
rounded
squared
thelabel
white

[hilight\MetaPostSymbols]
ahangle
ahlength
bboxmargin
charcode
circmargin
day
defaultdx
defaultdy
defaultpen
defaultscale
labeloffset
linecap
linejoin
miterlimit
month
pausing
prologues
showstopping
time
tracingcapsules
tracingchoices
tracingcommands
tracingequations
tracinglostchars
tracingmacros
tracingonline
tracingoutput
tracingrestores
tracingspecs
tracingstats
tracingtitles
truecorners
warningcheck
year
background
currentpen
currentpicture
cuttings
defaultfont
extra_beginfig
extra_endfig
beveled
black
blue
bp
butt
cc
cm
dd
ditto
down
epsilon
evenly
false
fullcircle
green
halfcircle
identity
in
infinity
left
mitered
mm
nullpicture
origin
pc
pencircle
pensquare
pt
quartercircle
red
right
rounded
squared
true
unitsquare
up
white
withdots

[hilight\MetaPostOperators]
&
*
**
+
++
+-+
-
/
<
=
>
<=
>=
abs
and
angle
arclength
arctime
ASCII
bbox
bluepart
boolean
bot
ceiling
center
char
color
cosd
cutafter
cutbefore
cycle
decimal
dir
direction
directionpoint
directiontime
div
dotprod
floor
fontsize
greenpart
hex
infont
intersectionpoint
intersectiontimes
inverse
known
length
lft
llcorner
lrcorner
makepath
makepen
mexp
mlog
mod
normaldeviate
not
numeric
oct
odd
or
pair
path
pen
penoffset
picture
point
postcontrol
precontrol
redpart
reverse
rotated
round
rt
scaled
shifted
sind
slanted
sqrt
str
string
subpath
substring
top
transform
transformed
ulcorner
uniformdeviate
unitvector
unknown
urcorner
whatever
xpart
xscaled
xxpart
xypart
ypart
yscaled
yxpart
yypart
zscaled

[CodeTree]
beginfig endfig
def enddef
begingroup endgroup
for endfor

// Defines comment commands
// single - symbol starting a comment ending by the end of line
// double - starting and ending symbols of the comment
[hilight\comments\MetaPostComments]
single=%
double=

// Defines hints for keywords. Each hint is a nicetext.
[hints]
fill=
\contentsline=/l57001/l
\numberline=/l57002/l
\ignorespaces=/l57003/l

// This section defines commands related to the group of files
// Syntaxt of the row:
//     name     - command name (nicetext)
//     bitmap   - bitmap code from resources
//     shortcut - hotkey 
//     label    - (nicetext)
//     hint     - (nicetext)
//     command  - command to execute
//
// Command syntax:
//     exec:nicetext - execute nicetext
//     ins:nicetext' - insert nicetext to the editor window (_ denotes cursor position)
//
// Predefined constants:
//     <PROGRAMDIR>       - LEd directory
//     <PROJECT>          - full path of the project, e.g., C:\Papers\Newest.lpr
//     <PROJECTDIR>       - project directory, e.g., C:\Papers
//     <PROJECTNAME>      - project name, e.g., Newest
//     <PROJECTNAMEEXT>   - project name with extension, e.g., Newest.lpr
//     <MAINFILE>         - full path to the main project file, e.g., C:\Papers\Main.tex
//     <MAINFILEDIR>      - directory name of the main project file, e.g., C:\Papers
//     <MAINFILENAME>     - main file name, e.g., Main
//     <MAINFILENAMEEXT>  - main file name with extension, e.g., Main.tex
//     <FILE>             - full path to the selected file
//     <FILEDIR>          - directory of the selected file
//     <FILENAME>         - selected file name
//     <FILENAMEEXT>      - selected file name with extension
//     <BatchesDir>       - directory with LEd batches
//     <DefinitionsDir>   - directory with LEd definitions
//     <DictionariesDir>  - directory with LEd dictionaries
//     <LanguagesDir>     - directory with LEd language resources
//     <ProjectsDir>      - default LEd directory for projects
//     <TemplatesDir>     - directory with LEd templates
//     <ResourcesDir>     - directory with LEd resources
[commands]
11012=11012=Ctrl+F6=MetaPost=/l53012/l=exec:metapost.bat <FILEDIR> <FILENAME> <FILEDISK>
11013=11013=Ctrl+Shift+F6=MetaPostAll=/l53013/l=exec[mp]:metapost.bat <FILEDIR> <FILENAME> <FILEDISK>


[popupmenu]
11012
11013

// Example for syntaxt hilighting for the group of files
[syntaxexample\MetaPostKeys,MetaPostOperators,MetaPostComments,MetaPostSymbols]
=beginfig(1);
=pickup pencircle scaled 0.5pt;
=draw begingraph(3.56in, 2.0in);
=glabel.lft(btex \font\textsf=phvr8r \textsf \vbox{\hbox{average} \hbox{MTF symbol}} etex, OUT);
=glabel.bot(btex \font\textsf=phvr8r \textsf file position etex, OUT);
=setrange(origin, whatever, whatever);

