/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import de.nm.ant.ipdf.AbstractPdfTask;
import de.nm.ant.ipdf.pages.InsertPageRule;
import de.nm.ant.ipdf.range.PageRange;
import de.nm.ant.ipdf.types.Pages;
import de.nm.ant.ipdf.types.PdfFilePages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class PdfInsertTask
extends AbstractPdfTask {
    private final List<Pages> pdffiles = new ArrayList<Pages>();
    private ArrayList<InsertPageRule> pdflisteafter;
    private ArrayList<InsertPageRule> pdflistebefore;

    public void addPages(Pages set) {
        this.pdffiles.add(set);
    }

    public void addPdfFilePages(PdfFilePages set) {
        this.pdffiles.add(set);
    }

    private void createInsert() throws FileNotFoundException {
        this.pdflistebefore = new ArrayList();
        this.pdflisteafter = new ArrayList();
        for (Pages fs : this.pdffiles) {
            InsertPageRule ipr;
            PageRange pr;
            int beforepage = fs.getBeforepage();
            int afterpage = fs.getAfterpage();
            boolean empty = fs.isEmpty();
            if (beforepage == -99 && afterpage == -99) {
                throw new BuildException("pdfinsert: beforepage or afterpage must be set!");
            }
            File f = null;
            if (fs instanceof PdfFilePages) {
                PdfFilePages pfs = (PdfFilePages)fs;
                pr = new PageRange(pfs.getPages());
                f = pfs.getFile();
                if (f == null) {
                    throw new BuildException("pdffilepage: file must be set!");
                }
                if (!f.exists()) {
                    throw new FileNotFoundException(f.getAbsolutePath());
                }
            } else {
                pr = new PageRange();
            }
            if (beforepage != -99) {
                ipr = new InsertPageRule(beforepage, pr, f, empty);
                this.pdflistebefore.add(ipr);
            } else {
                ipr = new InsertPageRule(afterpage, pr, f, empty);
                this.pdflisteafter.add(ipr);
            }
            ipr.setLandscape(fs.isLandscape());
            ipr.setPagesize(fs.getPagesize());
        }
        Comparator<InsertPageRule> comperator = new Comparator<InsertPageRule>(){

            @Override
            public int compare(InsertPageRule o1, InsertPageRule o2) {
                return o1.getPage() > o2.getPage() ? 1 : -1;
            }
        };
        Collections.sort(this.pdflistebefore, comperator);
        Collections.sort(this.pdflisteafter, comperator);
    }

    private ArrayList<InsertPageRule> createPageList(int page, boolean before) {
        ArrayList<InsertPageRule> il = new ArrayList<InsertPageRule>();
        boolean found = false;
        int n = before ? this.pdflistebefore.size() : this.pdflisteafter.size();
        for (int i = 0; i < n; ++i) {
            InsertPageRule ir;
            InsertPageRule insertPageRule = ir = before ? this.pdflistebefore.get(i) : this.pdflisteafter.get(i);
            if (ir.getPage() == page) {
                il.add(ir);
                found = true;
                continue;
            }
            if (found && ir.getPage() != page) break;
        }
        return il;
    }

    public void execute() {
        try {
            File input = this.getInputFile("pdf", this.usesrcfile);
            File output = this.getOutputFile("pdf");
            this.logVerboseHeader(input);
            this.createInsert();
            PdfReader reader = this.createPdfReaderFromFile(input);
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, this.createOutputStream(output));
            copy.setPdfVersion(this.version);
            document.open();
            int numberOfPages = reader.getNumberOfPages();
            for (int i = 1; i <= numberOfPages; ++i) {
                this.insertPdf(copy, i, true);
                if (i == numberOfPages) {
                    this.insertPdf(copy, -1, true);
                }
                copy.addPage(copy.getImportedPage(reader, i));
                this.insertPdf(copy, i, false);
                if (i != numberOfPages) continue;
                this.insertPdf(copy, -1, false);
            }
            document.close();
            copy.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    private void insertPdf(PdfCopy copy, int i, boolean before) throws IOException, BadPdfFormatException {
        ArrayList<InsertPageRule> il = this.createPageList(i, before);
        int n = il.size();
        for (int ip = 0; ip < n; ++ip) {
            InsertPageRule ir = il.get(ip);
            if (ir.isEmpty()) {
                copy.addPage(this.createEmptyPage(ir.getPagesize(), ir.isLandscape()), 0);
                continue;
            }
            File infile = ir.getPdffile();
            if (infile == null) {
                throw new BuildException("pdfinsert: 'file' not set!");
            }
            if (!infile.exists()) {
                throw new BuildException("pdfinsert: file " + infile.getAbsolutePath() + " not found!");
            }
            PdfReader inreader = this.createPdfReaderFromFile(infile);
            PageRange pr = ir.getPagerange();
            int mp = inreader.getNumberOfPages();
            pr.setMaxPage(mp);
            for (int p = 1; p <= mp; ++p) {
                if (!pr.isPageinRange(p)) continue;
                if (this.verbose) {
                    this.log("insert: " + infile + "(" + p + ")", 2);
                }
                copy.addPage(copy.getImportedPage(inreader, p));
            }
        }
    }
}

