/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import de.nm.ant.ipdf.AbstractPdfTask;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class PdfNupTask
extends AbstractPdfTask {
    private boolean center = true;
    private float even_bottom = 0.0f;
    private float even_left = 0.0f;
    private float even_right = 0.0f;
    private float even_top = 0.0f;
    private float hgap = 0.0f;
    private int hpages = 1;
    private boolean landscape = false;
    private float odd_bottom = 0.0f;
    private float odd_left = 0.0f;
    private float odd_right = 0.0f;
    private float odd_top = 0.0f;
    private String pagesize = "A4";
    private float vgap = 0.0f;
    private int vpages = 1;

    public void execute() {
        try {
            File input = this.getInputFile("pdf", this.usesrcfile);
            File output = this.getOutputFile("pdf");
            this.logVerboseHeader(input);
            PdfReader reader = new PdfReader(input.getAbsolutePath());
            Rectangle masterPageSize = this.createEmptyPage(this.pagesize, this.landscape);
            Document document = new Document(masterPageSize, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)this.createOutputStream(output));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int total = reader.getNumberOfPages();
            int n = this.hpages * this.vpages;
            int actualPage = 1;
            int masterpage = 1;
            while (actualPage <= total) {
                int v = 0;
                while (actualPage <= total && v < this.vpages) {
                    int h = 0;
                    while (actualPage <= total && h < this.hpages) {
                        float bottom;
                        float top;
                        float right;
                        float left;
                        if (masterpage % 2 == 0) {
                            left = this.even_left;
                            right = this.even_right;
                            top = this.even_top;
                            bottom = this.even_bottom;
                        } else {
                            left = this.odd_left;
                            right = this.odd_right;
                            top = this.odd_top;
                            bottom = this.odd_bottom;
                        }
                        Rectangle unitSize = new Rectangle((masterPageSize.getWidth() - left - right - this.hgap * (float)(this.hpages - 1)) / (float)this.hpages, (masterPageSize.getHeight() - top - bottom - this.vgap * (float)(this.vpages - 1)) / (float)this.vpages);
                        Rectangle currentSize = reader.getPageSize(actualPage);
                        PdfImportedPage page = writer.getImportedPage(reader, actualPage);
                        float factor = Math.min(unitSize.getWidth() / currentSize.getWidth(), unitSize.getHeight() / currentSize.getHeight());
                        float hcenter = 0.0f;
                        float vcenter = 0.0f;
                        if (this.center) {
                            hcenter = (unitSize.getWidth() - currentSize.getWidth() * factor) / 2.0f;
                            vcenter = (unitSize.getHeight() - currentSize.getHeight() * factor) / 2.0f;
                        }
                        float offsetX = unitSize.getWidth() * (float)((actualPage - 1) % n % this.hpages) + hcenter + left + this.hgap * (float)h;
                        float offsetY = masterPageSize.getHeight() - unitSize.getHeight() * (float)((actualPage - 1) % n / this.hpages + 1) + vcenter - top - this.vgap * (float)v;
                        cb.addTemplate((PdfTemplate)page, factor, 0.0f, 0.0f, factor, offsetX, offsetY);
                        if (this.debug) {
                            PdfContentByte canvas = writer.getDirectContent();
                            canvas.saveState();
                            canvas.setLineWidth(2.0f);
                            canvas.setRGBColorStroke(255, 0, 0);
                            canvas.rectangle(offsetX - hcenter, offsetY - vcenter, unitSize.getWidth(), unitSize.getHeight());
                            canvas.stroke();
                            canvas.restoreState();
                        }
                        if (++actualPage > total) break;
                        ++h;
                    }
                    ++v;
                }
                document.newPage();
                ++masterpage;
            }
            document.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public void setHgap(float hgap) {
        this.hgap = hgap;
    }

    public void setHpages(int hpages) {
        this.hpages = hpages;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public void setMargin(String margin) {
        if (margin != null) {
            String[] split = margin.split("\\s", 4);
            try {
                this.odd_left = Float.parseFloat(split[0]);
                this.odd_right = Float.parseFloat(split[1]);
                this.odd_top = Float.parseFloat(split[2]);
                this.odd_bottom = Float.parseFloat(split[3]);
                this.even_left = this.odd_left;
                this.even_right = this.odd_right;
                this.even_top = this.odd_top;
                this.even_bottom = this.odd_bottom;
            }
            catch (NumberFormatException e) {
                this.throwBuildException(e);
            }
        }
    }

    public void setMarginEven(String margin) {
        if (margin != null) {
            String[] split = margin.split("\\s", 4);
            try {
                this.even_left = Float.parseFloat(split[0]);
                this.even_right = Float.parseFloat(split[1]);
                this.even_top = Float.parseFloat(split[2]);
                this.even_bottom = Float.parseFloat(split[3]);
            }
            catch (NumberFormatException e) {
                this.throwBuildException(e);
            }
        }
    }

    public void setMarginOdd(String margin) {
        if (margin != null) {
            String[] split = margin.split("\\s", 4);
            try {
                this.odd_left = Float.parseFloat(split[0]);
                this.odd_right = Float.parseFloat(split[1]);
                this.odd_top = Float.parseFloat(split[2]);
                this.odd_bottom = Float.parseFloat(split[3]);
            }
            catch (NumberFormatException e) {
                this.throwBuildException(e);
            }
        }
    }

    public void setPagesize(String pagesize) {
        this.pagesize = pagesize;
    }

    public void setVgap(float vgap) {
        this.vgap = vgap;
    }

    public void setVpages(int vpages) {
        this.vpages = vpages;
    }
}

