/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.config;

import de.nm.ant.AbstractWorkerTask;
import de.nm.file.XFile;
import de.nm.object.XObject;
import de.nm.string.XString;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class VariableTask
extends AbstractWorkerTask {
    private String osname = null;
    private static final String REF_PROPERTY_HELPER = "ant.PropertyHelper";
    private static final String USERPROP = "userProperties";
    private static final String PROP = "properties";
    private String name = null;
    private boolean remove = false;
    private String value = "";
    private File file = null;
    private static String os = System.getProperty("os.name");

    public void setOsname(String osname) {
        this.osname = osname;
    }

    public static synchronized void removeProperty(Project project, String name) {
        block14: {
            Hashtable properties = null;
            try {
                properties = (Hashtable)XObject.getValue((Object)project, (String)PROP);
                if (properties != null) {
                    properties.remove(name);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                properties = (Hashtable)XObject.getValue((Object)project, (String)USERPROP);
                if (properties != null) {
                    properties.remove(name);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Object property_helper = project.getReference(REF_PROPERTY_HELPER);
                if (property_helper == null) break block14;
                try {
                    properties = (Hashtable)XObject.getValue((Object)property_helper, (String)PROP);
                    if (properties != null) {
                        properties.remove(name);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    properties = (Hashtable)XObject.getValue((Object)property_helper, (String)USERPROP);
                    if (properties != null) {
                        properties.remove(name);
                    }
                }
                catch (Exception e) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized void setProperty(Project project, String name, String value) {
        String newvalue = project.replaceProperties(value);
        try {
            Hashtable properties = (Hashtable)XObject.getValue((Object)project, (String)PROP);
            if (properties == null) {
                project.setUserProperty(name, newvalue);
            } else {
                properties.put(name, newvalue);
            }
        }
        catch (Exception e) {
            project.setUserProperty(name, newvalue);
        }
    }

    private void checkName() {
        if (this.name == null) {
            throw new BuildException("'name' must be set!");
        }
    }

    public void execute() throws BuildException {
        if (this.name == null && this.file == null) {
            throw new BuildException("'name' or 'file' must be set!");
        }
        if (this.osname == null || os.matches(this.osname)) {
            if (this.remove) {
                this.checkName();
                VariableTask.removeProperty(this.getProject(), this.name);
                this.logVerbose(XString.concat((String[])new String[]{"remove ", this.name}));
            } else if (this.file != null) {
                this.loadFile();
            } else {
                this.checkName();
                VariableTask.setProperty(this.getProject(), this.name, this.value);
                this.logVerbose(XString.concat((String[])new String[]{"set ", this.name, "=", this.value}));
            }
        } else {
            this.logDebug(XString.concat((String[])new String[]{"os not matching: ", os, " != ", this.osname}));
        }
    }

    private void loadFile() {
        if (!this.file.exists()) {
            throw new BuildException("file '" + this.file.getName() + "' dont exists!");
        }
        try {
            this.logVerbose(this.file, " loading properties.");
            Properties props = new Properties();
            props.load(XFile.getReader((File)this.file, (String)this.encoding));
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                String value = props.getProperty(name);
                VariableTask.setProperty(this.getProject(), name, value);
                this.logVerbose(XString.concat((String[])new String[]{"set ", name, "=", value}));
            }
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

