/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.util.ArrayList;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.BlockNode;
import org.mvel2.ast.NestedStatement;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ErrorUtil;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;

public class WithNode
extends BlockNode
implements NestedStatement {
    protected String nestParm;
    protected ParmValuePair[] withExpressions;

    public WithNode(char[] expr, int start, int offset, int blockStart, int blockOffset, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.nestParm = ParseTools.createStringTrimmed(expr, this.start, this.offset);
        this.blockStart = blockStart;
        this.blockOffset = blockOffset;
        if ((fields2 & 0x10) != 0) {
            pCtx.setBlockSymbols(true);
            this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx);
            this.egressType = this.compiledBlock.getKnownEgressType();
            this.withExpressions = WithNode.compileWithExpressions(expr, blockStart, blockOffset, this.nestParm, this.egressType, pCtx);
            pCtx.setBlockSymbols(false);
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object ctxObject = this.compiledBlock.getValue(ctx, thisValue, factory);
        if (ctxObject == null) {
            throw new CompileException("with-block against null pointer", this.expr, this.start);
        }
        for (ParmValuePair pvp : this.withExpressions) {
            pvp.eval(ctxObject, factory);
        }
        return ctxObject;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.expr, this.start, this.offset, ctx, factory);
        ParseTools.parseWithExpressions(this.nestParm, this.expr, this.blockStart, this.blockOffset, ctx, factory);
        return ctx;
    }

    public static ParmValuePair[] compileWithExpressions(char[] block, int start, int offset, String nestParm, Class egressType, ParserContext pCtx) {
        ArrayList<ParmValuePair> parms = new ArrayList<ParmValuePair>();
        String parm = "";
        int end2 = start + offset;
        int _st = start;
        int _end = -1;
        int oper = -1;
        block13: for (int i = start; i < end2; ++i) {
            switch (block[i]) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(block, i, end2, block[i]);
                    continue block13;
                }
                case '/': {
                    if (i < end2 && block[i + 1] == '/') {
                        while (i < end2 && block[i] != '\n') {
                            block[i++] = 32;
                        }
                        if (parm != null) continue block13;
                        _st = i;
                        continue block13;
                    }
                    if (i < end2 && block[i + 1] == '*') {
                        int len = end2 - 1;
                        while (i < len && (block[i] != '*' || block[i + 1] != '/')) {
                            block[i++] = 32;
                        }
                        block[i++] = 32;
                        block[i++] = 32;
                        if (parm != null) continue block13;
                        _st = i;
                        continue block13;
                    }
                    if (i >= end2 || block[i + 1] != '=') continue block13;
                    oper = 3;
                    continue block13;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': {
                    if (i + 1 >= end2 || block[i + 1] != '=') continue block13;
                    oper = ParseTools.opLookup(block[i]);
                    continue block13;
                }
                case '=': {
                    parm = ParseTools.createStringTrimmed(block, _st, i - _st - (oper != -1 ? 1 : 0));
                    _st = i + 1;
                    continue block13;
                }
                case ',': {
                    if (_end == -1) {
                        _end = i;
                    }
                    if (parm == null || parm.length() == 0) {
                        try {
                            String expr = nestParm == null ? new String(block, _st, _end - _st) : nestParm + '.' + new String(block, _st, _end - _st);
                            parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(expr, pCtx), egressType, pCtx));
                        }
                        catch (CompileException e) {
                            e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset)));
                            e.setExpr(block);
                            throw e;
                        }
                        oper = -1;
                        _st = ++i;
                    } else {
                        if (nestParm == null) {
                            throw new CompileException("operative assignment not possible here", block, start);
                        }
                        try {
                            parms.add(new ParmValuePair(parm, oper != -1 ? (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(nestParm + "." + parm, block, _st, _end - _st, oper), pCtx) : (ExecutableStatement)ParseTools.subCompileExpression(block, _st, _end - _st, pCtx), egressType, pCtx));
                        }
                        catch (CompileException e) {
                            e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset)));
                            e.setExpr(block);
                            throw e;
                        }
                        parm = null;
                        oper = -1;
                        _st = ++i;
                    }
                    _end = -1;
                }
            }
        }
        _end = end2;
        if (_st != _end) {
            try {
                if (parm == null || "".equals(parm)) {
                    String expr = nestParm == null ? new String(block, _st, _end - _st) : nestParm + '.' + new String(block, _st, _end - _st);
                    parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(expr, pCtx), egressType, pCtx));
                } else {
                    if (nestParm == null) {
                        throw new CompileException("operative assignment not possible here", block, start);
                    }
                    parms.add(new ParmValuePair(parm, oper != -1 ? (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(nestParm + "." + parm, block, _st, _end - _st, oper), pCtx) : (ExecutableStatement)ParseTools.subCompileExpression(block, _st, _end - _st, pCtx), egressType, pCtx));
                }
            }
            catch (CompileException e) {
                throw ErrorUtil.rewriteIfNeeded(e, block, _st);
            }
        }
        ParmValuePair[] withExpressions = new ParmValuePair[parms.size()];
        parms.toArray(withExpressions);
        return withExpressions;
    }

    @Override
    public ExecutableStatement getNestedStatement() {
        return this.compiledBlock;
    }

    public ParmValuePair[] getWithExpressions() {
        return this.withExpressions;
    }

    public static final class ParmValuePair
    implements Serializable {
        private Serializable setExpression;
        private ExecutableStatement statement;

        public ParmValuePair(String parameter, ExecutableStatement statement, Class ingressType, ParserContext pCtx) {
            if (parameter != null && parameter.length() != 0) {
                this.setExpression = MVEL.compileSetExpression(parameter, ingressType != null ? PropertyTools.getReturnType(ingressType, parameter, pCtx) : Object.class, pCtx);
            }
            this.statement = statement;
        }

        public Serializable getSetExpression() {
            return this.setExpression;
        }

        public ExecutableStatement getStatement() {
            return this.statement;
        }

        public void eval(Object ctx, VariableResolverFactory factory) {
            if (this.setExpression == null) {
                this.statement.getValue(ctx, factory);
            } else {
                MVEL.executeSetExpression(this.setExpression, ctx, factory, this.statement.getValue(ctx, factory));
            }
        }
    }
}

