/*
 * Created on Mar 27, 2003
 *
 * @author henkel@cs.colorado.edu
 * 
 */
package bibtex.dom.personlists;

import java.io.PrintWriter;

import bibtex.dom.BibtexNode;

/**
 * @author henkel
 */
public final class BibtexPersonList extends BibtexNode {

	public BibtexPersonList(BibtexPerson [] list){
		this.list = list;
	}

	private BibtexPerson [] list;

	/**
	 * Note: The returned list is live, which means that changing it changes the state of the object!
	 * 
	 * @return BibtexPerson
	 */
	public BibtexPerson [] getList() {
		return list;
	}


	/* (non-Javadoc)
	 * @see bibtex.dom.BibtexNode#printBibtex(java.io.PrintWriter)
	 */
	public void print(PrintWriter writer) {
		for(int i=0;i<list.length;i++){
			if(i!=0) writer.print(" and ");
			list[i].print(writer);
		}
	}

}
