program cbuncode;

uses
  crt, dos, ch_files;

var
  source, target : sourcetype;
  game : gametype;
  i : integer;
  numb_of_games, game_numb, temp : longint;
  choice : string;

{mainprogram}
begin
  io_test;
  writeln;
  writeln('CBUNCODE is useful, if it is impossible to convert your ChessBase');
  writeln('gamefiles to NicBase using NicTools made by NicBase');
  writeln;
  if paramcount=2 then
  begin
    source.name:=paramstr(1);
    target.name:=paramstr(2);
  end
  else
  if paramcount=1 then
  begin
    source.name:=paramstr(1);
    write('Type name of new and uncoded file:                     ');
    readln(target.name);
  end
  else
  begin
    write('Type name of file impossible to convert to Nicbase:    ');
    readln(source.name);
    write('Type name of new and uncoded file:                     ');
    readln(target.name);
  end;
  remove_ext(source.name);
  remove_ext(target.name);
  writeln;
  choice:='N';
  find_path(source.name,source.path);
  find_path(target.name,target.path);
  while  (file_exist(target.path+target.name+'.CBI') and
         file_exist(target.path+target.name+'.CBF')) and
         (choice<>'Y') do
  begin
    choice:='Y';
    write('Target file: ',target.name,' Already exists! Overwrite (y/n)?   ');
    readln(choice);
    choice:=upcasestr(copy(choice,1,1));
    if choice='N' then
    begin
      write('Type name of new and uncoded file:                     ');
      readln(target.name);
      remove_ext(target.name);
      find_path(target.name,target.path);
    end;
  end;
  if file_exist(source.path+source.name+'.CBI') and
     file_exist(source.path+source.name+'.CBF') then
  begin
    if source.path+source.name=target.path+target.name then
    begin
      writeln('Source and Target are not allowed to be identical');
      io_error:=true;
    end
    else
    begin
      open_file_for_read(source.index  ,source.path+source.name+'.CBI');
      open_file_for_read(source.game   ,source.path+source.name+'.CBF');
      open_file_for_write(target.index ,target.path+target.name+'.CBI');
      open_file_for_write(target.game  ,target.path+target.name+'.CBF');
    end;
    if not io_error then
    begin
      game_numb:=1;
      numb_of_games:=get_index_val(source.index)-1;
      game.beg:=get_index_val(source.index)-game_numb-1;
      writeln(numb_of_games:6,' Games to examine');
      while (game_numb<=numb_of_games) and (not io_error) do
      begin
        game.beg_next:=get_index_val(source.index)-game_numb-2;
        game.len:=game.beg_next-game.beg;
        while (source.game.pos+1<game.beg) do
        begin
          put_next_byte(target.game,get_next_byte(source.game));
        end;
        for i:=0 to game.len-1 do
        begin
          game.bytes[i]:=get_next_byte(source.game);
        end;
        game.bytes[game.len]:=-1;
        game.bytes[4]:=128 or game.bytes[4] and 63;
        game.bytes[5]:=128 or game.bytes[5] and 63;
        for i:=0 to game.len-1 do
        begin
          put_next_byte(target.game,game.bytes[i]);
        end;
        game.beg:=game.beg_next;
        gotoxy(1,wherey);
        write(game_numb:6,' Games Examined    ');
        inc(game_numb);
      end;
    end;
    writeln;
    close_read_file(source.index);
    close_read_file(source.game);
    if (not io_error) then
    begin
      open_file_for_read(source.index  ,source.path+source.name+'.CBI');
      game_numb:=1;
      while (game_numb<=numb_of_games+2) and (not io_error) do
      begin
        temp:=get_index_val(source.index);
        put_index_val(target.index,temp);
        inc(game_numb);
        if ((game_numb mod 10)=0) then
          write('.');
      end;
      writeln;
      close_read_file(source.index);
    end;
    close_write_file(target.game);
    close_write_file(target.index);
  end
  else
  begin
    writeln(source.path+source.name,'* Does not exist');
  end;
end.
