/*
 * TalkRecord.java
 *
 * Created on 10. November 2005, 7:11
 */


/**
 *
 *  This class represents an entry of the data base`s table "talks".
 *
 * @author  Olle Nebendahl
 */

class TalkRecord
{   
    private int talkId;
    private String title;
    private String subject;
    private String sourceFileName;
    private String originalFileName;
    private int firstSlide;
    
    public int getTalkId(){ return talkId; }
    public void setTalkId(int i){talkId=i; }

    public void setTitle(String s){ title=s; }        
    public String getTitle() { return new String(title); }

    public void setSubject(String s){ subject=s; }        
    public String getSubject() { return new String(subject); }

    public void setSourceFileName(String s){ sourceFileName=s; }        
    public String getSourceFileName() { return new String(sourceFileName); }

    public void setOriginalFileName(String s){ originalFileName=s; }        
    public String getOriginalFileName() { return new String(originalFileName); }

    int getFirstSlide()    { return firstSlide; }
    void setFirstSlide(int i) {   firstSlide=i; }
    
    TalkRecord()
    {
        talkId = Constants.NO_TALK_ID;
        firstSlide = Constants.NO_SLIDE_ID;
    }

    public TalkRecord clone()
    {
        return new TalkRecord(this);
    }
    

    TalkRecord(TalkRecord tr)
    {
        talkId = tr.talkId;
        title = tr.title;
        subject = tr.subject;
        sourceFileName = tr.sourceFileName;
        originalFileName = tr.originalFileName;
        firstSlide = tr.firstSlide;
    }
    

    public String toString()
    {
        return getTitle()+", "+getSourceFileName();
    }
    
    public String toFullString()
    {
        String s;
        if(getFirstSlide()==Constants.NO_SLIDE_ID)s=new String("No slide is attached to this talk.");
        else s=new String("This talk`s first slide has ID: "+getFirstSlide());
        return(getTalkId()+"\n"+getTitle()+"\n"+getSubject()+"\n"+getSourceFileName()+"\n"+getOriginalFileName()+"\n"+s);
    }
}
