﻿Module csvtolatex

    Sub Main(ByVal args() As String)

        Const version = "1.3"
        Dim iPath, ePfad, mode, Fso, iFile, Text, geteilt, nCount, configPath, config, mess, running, options, comma
        Const title = "csvtolatex " & version
        If args.Length = 0 Then
            configPath = InputBox("Please write the path to your configuration file (*.ctl):", title)
        Else
            configPath = args(0)
        End If

        config = False
        running = False

        Try
            Fso = CreateObject("Scripting.FileSystemObject")
            iFile = Fso.OpenTextFile(configPath)
            'Catch bug As System.IO.FileNotFoundException
            '    mess = MsgBox("configurationfile not found", 0, title)
            '    csvtolatex.Exit()
            '    'Catch ex As Exception
            'mess = MsgBox("Something is wrong with your configurationfile or your path.", 0, title)
            'csvtolatex.Exit()
            'End Try

            'Try
            Do Until iFile.AtEndOfStream
                Text = iFile.ReadLine
                If InStr(Text, "input=") Then
                    Text = Replace(Text, "input=", "")
                    iPath = Trim(Text)
                End If
                If InStr(Text, "output=") Then
                    If InStr(Text, "output=config=") Then
                        config = True
                    End If
                    Text = Replace(Text, "output=config=", "")
                    Text = Replace(Text, "output=", "")
                    ePfad = Trim(Text)
                End If
                If InStr(Text, "mode=") Then
                    Text = Replace(Text, "mode=", "")
                    mode = Trim(Text)
                End If
                If InStr(Text, "options=") Then
                    Text = Replace(Text, "options=", "")
                    options = Trim(Text)
                End If
                If InStr(Text, "commatopoint") Then
                    comma = "ctp"
                End If
                If InStr(Text, "pointtocomma") Then
                    comma = "ptc"
                End If
            Loop

            If InStr(iPath, ":\") Then
            Else
                geteilt = Split(configPath, "\")
                nCount = UBound(geteilt, 1) - LBound(geteilt, 1)
                iPath = Replace(configPath, geteilt(nCount), "") & iPath
                iPath = Replace(iPath, "\\", "\")
            End If

            If InStr(ePfad, ":\") Then
            Else
                If config Then
                    Text = configPath
                Else
                    Text = iPath
                End If
                geteilt = Split(Text, "\")
                nCount = UBound(geteilt, 1) - LBound(geteilt, 1)
                ePfad = Replace(Text, geteilt(nCount), "") & ePfad
                ePfad = Replace(ePfad, "\\", "\")
                If (CInt(InStrRev(ePfad, "\")) = CInt(Len(ePfad))) Then
                Else
                    ePfad = ePfad & "\"
                End If
            End If

            If InStr(mode, "math") Then
                mode = "$"
            ElseIf InStr(mode, "text") Then
                mode = ""
            Else
                mode = "$"
            End If

            Text = ""
            Dim index, delete, lineend, zusatztext, first, spundzetrenner
            Dim mnumber, worktext, testnumber, zwischen, addition, arbeitstext, indexi, muellzahl, head
            index = "0"
            delete = "@€€@µ"
            first = True

            If InStr(options, "nolines") Then
                spundzetrenner = ""
            Else
                spundzetrenner = "|"
            End If

            Dim eFile, ePath


            Fso = CreateObject("Scripting.FileSystemObject")
            iFile = Fso.OpenTextFile(iPath)


            Do Until iFile.AtEndOfStream
                Text = iFile.ReadLine
                Do While ((InStr(Text, " //")) Or (InStr(Text, "// ")))
                    Text = Replace(Text, " //", "//")
                    Text = Replace(Text, "// ", "//")
                Loop
                Do While ((InStr(Text, ";//;")))
                    Text = Replace(Text, ";//;", ";//")
                Loop
                Text = Replace(Text, ";/endhead", ";// /endhead")
                Do While ((InStr(Text, "/endhead;")))
                    Text = Replace(Text, "/endhead;", "/endhead")
                Loop
                If ((InStr(Text, ";//")) And running) Then
                    Dim muell
                    Text = Replace(Text, ";//", "")
                    arbeitstext = ""
                    geteilt = Split(Text, ";")
                    indexi = "0"
                    nCount = UBound(geteilt, 1) - LBound(geteilt, 1) + 1
                    If first Then
                        first = False
                        Dim columns
                        columns = "% " & spundzetrenner
                        For indi = 1 To nCount Step 1
                            columns = columns & "c" & spundzetrenner
                        Next
                        Dim coltext
                        coltext = "% number of columns: " & nCount
                        eFile.WriteLine(coltext)
                        eFile.WriteLine(columns)
                    End If
                    muellzahl = "0"
                    zusatztext = mode
                    Do
                        zwischen = 1
                        If InStr(geteilt(indexi), "/multicolumn{") Then
                            mnumber = InStr(geteilt(indexi), "/multicolumn{")
                            testnumber = InStr(geteilt(indexi), "}")
                            addition = "0"
                            zwischen = geteilt(indexi)
                            testnumber = testnumber - 1
                            zwischen = Left(zwischen, testnumber)
                            testnumber = InStrRev(zwischen, "{")
                            testnumber = Len(zwischen) - testnumber
                            zwischen = Right(zwischen, testnumber)
                            geteilt(indexi) = Replace(geteilt(indexi), "/multicolumn{", "\multicolumn{")
                            zusatztext = ""
                        ElseIf InStr(geteilt(indexi), "/multirow{") Then
                            geteilt(indexi) = Replace(geteilt(indexi), "/multirow{", " \multirow{")
                            zusatztext = ""
                        ElseIf ((Len(geteilt(indexi)) = 0) Or InStr(Text, "/cline{") Or InStr(Text, "\cline{")) Then
                            zusatztext = ""
                        Else
                            zusatztext = mode
                        End If
                        testnumber = indexi + 1
                        If InStr(testnumber, nCount) Then
                            arbeitstext = arbeitstext & zusatztext & geteilt(indexi) & zusatztext
                        Else
                            testnumber = indexi + zwischen
                            If (InStr(testnumber, nCount) And InStr(geteilt(indexi), "\multicolumn{")) Then
                                arbeitstext = arbeitstext & zusatztext & geteilt(indexi) & zusatztext
                            Else
                                arbeitstext = arbeitstext & zusatztext & geteilt(indexi) & zusatztext & " & "
                            End If
                        End If
                        indexi = indexi + zwischen
                    Loop Until (InStr(indexi, nCount))
                    Text = arbeitstext
                    head = " "
                    If InStr(Text, "/endhead") Then
                        Text = Replace(Text, "/endhead", "")
                        head = " \endhead "
                    End If
                    lineend = "\hline"
                    If InStr(Text, "/cline{") Then
                        Text = Replace(Text, "/cline{", "\cline{")
                    End If
                    If InStr(Text, "\cline{") Then
                        mnumber = InStr(Text, "\cline{") - 1
                        arbeitstext = Left(Text, mnumber)
                        zwischen = Replace(Text, arbeitstext, "")
                        lineend = zwischen
                        Text = arbeitstext
                    End If
                    If InStr(Text, "/hline") Then
                        Text = Replace(Text, "/hline", "")
                        lineend = lineend & "\hline"
                    End If
                    If InStr(options, "nolines") Then
                        lineend = ""
                    End If
                    Text = Replace(Text, "/.,", ";")
                    Text = Text & "\\ " & lineend & head
                    Text = Replace(Text, " & " & mode & "/blank" & mode, " & ")
                    Text = Replace(Text, " & " & "/blank", " & ")
                    Text = Replace(Text, "/blank", "")
                    If InStr(comma, "ctp") Then
                        While InStr(Text, ",")
                            Text = Replace(Text, ",", ".")
                        End While
                    ElseIf InStr(comma, "ctp") Then
                        While InStr(Text, ".")
                            Text = Replace(Text, ",", ".")
                        End While
                    End If
                eFile.WriteLine(Text)
                End If
                If InStr(Text, "/begin{") Then
                    Text = Replace(Text, "/begin{", "")
                    Text = Replace(Text, ";", "")
                    ePath = ePfad & Replace(Text, "}", "")
                    first = True
                    running = True
                    eFile = Fso.CreateTextFile(ePath)
                End If
                If InStr(Text, "/end") Then
                    eFile.Close()
                    running = False
                    first = False
                End If
            Loop
                iFile.Close()


                Text = MsgBox("Conversion complete!", 0, title)
        Catch bug As System.IO.FileNotFoundException
            mess = MsgBox("configurationfile not found. Your written path is: " & configPath, 0, title)
        Catch ex As System.ArgumentException
            mess = MsgBox("Something is wrong here, please check your configuration file or your configuration path. Your written path is: " & configPath, 0, title)
        Catch e As Exception
            mess = MsgBox("Something is wrong here, please check your configuration file.", 0, title)
        End Try

    End Sub

End Module