program PrET;
{   C  John Collins.
    Prints out draft of ET file.

12 Jun 96 JCC  Make NonumbPg1 work: the wrong condition is applied
13 Nov 95 JCC  I've fixed the printer-off-line bug, I think.
12 Nov 95 JCC  Test version to correct bug: printer off line => no files
               are printed, 2nd file => file doesn't exist message.
               See pretsub2. And ??'s
               IOChecking on.
26 Oct 93 JCC  Correct bug on EPSON. paperheight and paperwidth
13 Feb 93 JCC  Start to implement HPLJ.
               ==> Fractions don't always work.  Need to check that
               pret still works with other printers.  See \john\tmp.*
               for test files.
13 Feb 93 JCC  Set page layout.
11 Feb 91 JCC  \page command
11 Oct 90 JCC  \perp added
 4 Sep 90 JCC  Corrections to graphics mode.
30,31 Aug 90 JCC  Start IBM Proprinter installation.  Switch between
               graphics and downloaded font -- for EPSON and IBM.
27 Aug 90 JCC  Remove use of download font for EPSON.
 7 Jun 90 JCC  Fractions
 6 Jun 90 JCC  Variable line height for math.
29 Dec 89 JCC  Command line switches.  Multiple files on command line.
               MPI and TTY printers.
               Temporarily comment out Raw.
 1 Dec 89 JCC  Raw mode for printer.
29 Nov 89 JCC  Allow long generated lines
18 Oct 89 JCC  Modify line height in displayed equations.
 4 Oct 89 JCC  Signon message.
 3 Oct 89 JCC  New ET control codes.
22 Sep 89 JCC  Move pretprn only contains code for specific printers
               Correct usage message.
11 Sep 89 JCC  Copy from PRTEX.
 }

{$I etdirect.inc}            {Directives shared by all units}
{$I+}{??}
Uses ETsyms, pretdef1, pretsub2, pretprn1, conv, utils;

const
   ID : string[32] = 'PRET Installation area.';
   SignOn  : string   = 'ET draft printer 1.15.  JCC 13 Nov 95';
   DefPrinter : filename = 'EPSON';     { Defaults.  }
   DefOutName : filename = 'PRN';
   DefExt  : string[4]= '.ET';
   Terminator : char = #0;
   UseStdIn : boolean = false;  {if true, then take input from stdin, not file.}

var
   CmdLine : ParsedCmdLine;
   Printer, fn : FileName;
   InitState, MyState : State;
   i : integer;
   Error : boolean;

procedure help;
begin
   writeln ('Usage:');
   writeln ('   PRET  switches files ');
   writeln ('makes draft of ET file(s).  Default extension ''',DefExt,'''.');
   writeln ('File names must be separated by spaces.');
   writeln ('   PRET ?');
   writeln ('or');
   writeln ('   PRET /help');
   writeln ('for detailed help.');
   writeln ('    ');
   writeln ('Default printer: ', DefPrinter, ';  default output: ', DefOutName);
   writeln ('Current printer: ', Printer,
            ';  current output to: ', InitState.DestName);
   {Line 11 done}
   with InitState do begin
      write ('Current lines per inch = ', VDPI div LH, '.  ');
      writeln;
      write ('Paper height = ', paperheight:3:1, '".  ');
      write ('Paper width = ',  paperwidth:3:1, '".  ');
      writeln;
      write ('Top margin = ', mt:3:1, '".  ');
      write ('Bottom margin = ', mb:3:1, '".  ');
{      write ('Header margin = ', hm:3:1, '".  ');}
      write ('Footer margin = ', fm:3:1, '".  ');
      writeln;
      if GraphSwitchPoss then begin
         if (UseGraph = GrYes) or ( (UseGraph = GrDef) and (ThisGraphDef) )then
            writeln ('Graphics for Greek/symbols.  ')
         else
            writeln ('Downloaded font for Greek/symbols.  ');
      end else
         writeln;
   end;
   writeln;
   writeln ('Switches and files may be in any order, and may be mixed.');
   writeln ('Switches are obeyed in order of occurence.  No ''wildcards''');
   writeln ('allowed in file names.  Upper and lower case are equivalent.');
   writeln ('Legal switches:');
   writeln ('    /help             for this message.');
   writeln;
   {Line 22 done}
   write   ('Type C/R to continue:');
   readln;
   writeln ('    /printer=NAME     Defines type of printer.');
   writeln ('    /out=NAME         Define output device or file.');
   writeln ('    /LPI=n            Sets line height in lines per inch.  ');
   writeln ('    /graphics or /nographics   set use of graphics or downloaded font.');
   writeln ('    /mt=n             Sets top margin in inches.  ');
   writeln ('    /mb=n             Sets bottom margin in inches.  ');
   writeln ('    /fm=n             Sets footer margin in inches.  ');
   writeln ('    /paperwidth=n     Sets paper width in inches.  ');
   writeln ('    /paperheight=n    Sets paper height in inches.  ');
   writeln ('    /nonumber /number Controls use of page numbers.');
   writeln ('    /nonum1 /num1     Controls use of number for page 1.');
   writeln ('Supported printers');
   ListPrs (output);
   writeln ('    ');
   writeln ('Possible output devices: PRN, AUX for any MSDOS computer.');
   writeln ('LPT1, COM1, possibly LPT2, COM2, etc, for IBM compatibles.');
   writeln ('Also, any legal MSDOS file or device name.  (Thus output can be');
   writeln ('can be sent to a file.)  ');
   writeln ('Blank name for printer or output => use default.');
   {Line 19/2 done}
end;

procedure ObeyCmdLine;
   function nint (r: real): integer;
      begin nint := trunc(0.5+r); end;
   var i, valcode: integer;
       value: real;
begin
   with CmdLine do begin
      for i := 1 to NumSw do begin
         Val (Tail[i], Value, valcode);
         if GoodAbbrev (switch[i], 'PRINTER', 2) then begin
            if GoodPrName (tail[i]) then begin
               Printer := tail[i];
               SetPrinter (InitState, Printer);
            end else if tail[i] = '' then begin
               Printer := DefPrinter;
               SetPrinter (InitState, Printer);
            end else begin
               writeln ('Bad printer name: ''', tail[i], '''.');
               Error := true;
            end;
         end else if GoodAbbrev (switch[i], 'OUT', 2) then begin
            if Tail[i] <> '' then
               InitState.DestName := Tail[i]
            else
               InitState.DestName := DefOutName;
         end else if GoodAbbrev (switch[i], 'GR', 2) then begin
            InitState.UseGraph := GrYes;
         end else if GoodAbbrev(Switch[i], 'NOGRAPHICS', 4) then begin
            InitState.UseGraph := GrNo;
         end else if (switch[i] = 'LPI') then begin
            if (valcode = 0) and (value > 0) then
               InitState.LH := nint (InitState.VDPI / value)
            else begin
               writeln ('Illegal value in ''', SwOrigin[i], '''.');
               Error := true;
            end;
         end else if GoodAbbrev (switch[i], 'HELP', 1) then begin
            help;
         end else if GoodAbbrev (switch[i], 'STDIN', 4) then begin
            UseStdIn := true;
         end else if GoodAbbrev (switch[i], 'NOSTDIN', 6) then begin
            UseStdIn := false;
         end else if GoodAbbrev (switch[i], 'NUMBER', 4) then begin
            InitState.OmitNum := false;
         end else if GoodAbbrev (switch[i], 'NONUMBER', 6) then begin
            InitState.OmitNum := true;
         end else if GoodAbbrev (switch[i], 'NUM1', 4) then begin
            InitState.NumbPg1 := true;
         end else if GoodAbbrev (switch[i], 'NONUM1', 5) then begin
            InitState.NumbPg1 := false;
         end else if GoodAbbrev (switch[i], 'MB', 2) then begin
            if (valcode = 0) and (value >= 0) then begin
               InitState.mb := value;
               ImpliedSettings(InitState);
            end else begin
               writeln ('Illegal value in ''', SwOrigin[i], '''.');
               Error := true;
            end;
         end else if GoodAbbrev (switch[i], 'MT', 2) then begin
            if (valcode = 0) and (value >= 0) then begin
               InitState.mt := value;
               ImpliedSettings(InitState);
            end else begin
               writeln ('Illegal value in ''', SwOrigin[i], '''.');
               Error := true;
            end;
         end else if GoodAbbrev (switch[i], 'FM', 2) then begin
            if (valcode = 0) and (value >= 0) then begin
               InitState.fm := value;
               ImpliedSettings(InitState);
            end else begin
               writeln ('Illegal value in ''', SwOrigin[i], '''.');
               Error := true;
            end;
         end else if GoodAbbrev (switch[i], 'PAPERWIDTH', 6) then begin
            if (valcode = 0) and (value >= 0) then begin
               InitState.paperwidth := value;
               ImpliedSettings(InitState);
            end else begin
               writeln ('Illegal value in ''', SwOrigin[i], '''.');
               Error := true;
            end;
         end else if GoodAbbrev (switch[i], 'PAPERHEIGHT', 6) then begin
            if (valcode = 0) and (value >= 0) then begin
               InitState.paperheight := value;
               ImpliedSettings(InitState);
            end else begin
               writeln ('Illegal value in ''', SwOrigin[i], '''.');
               Error := true;
            end;
         end else begin
            writeln ('Bad switch name in ''', SwOrigin[i], '''.');
            Error := true;
         end;
      end {for};
   end {with};
   with InitState do begin
      if hm > mt then hm := mt;
      if fm > mb then fm := mb;
      ImpliedSettings(InitState);
   end;
end;

begin { main program.  }
{ InitState is the setup at the start of each file.
  Initialize settings, then allow them to be overridden.
  Make the initial settings now, so that the help system can access
  them.
}
   Printer := DefPrinter;
   InitState.DestName := DefOutName;
   InitState.UseGraph := GrDef;
   DefaultSettings (InitState);
   SetPrinter (InitState, Printer);
   Error := false;

   writeln (SignOn);
   if ParamCount = 0 then begin
      writeln ('Usage:');
      writeln ('   PRET  switches files ');
      writeln ('makes draft of ET file(s).  Default extension ''',DefExt,'''.');
      writeln ('PRET ?     or   PRET /HELP    for detailed help.');
      writeln ('Default printer: ', DefPrinter, '; default output: ', DefOutName);
      halt(1);
   end;
   if (ParamCount = 1) and (ParamStr(1) = '?') then begin
      help;
      halt(1);
   end;

   ParseCmd (CmdLine);
   ObeyCmdLine;
   if Error then begin
      writeln ('Errors.  I will not continue.');
      halt(10);
   end;

   writeln ('Printer: ', Printer, ';  output device: ', InitState.DestName);
   if UseStdIn then begin
      MyState := InitState;
      MyState.SourceName := '';
      ProcessFile (MyState);
   end else if CmdLine.NumFiles = 0 then
      writeln ('No files to process.');
   for i := 1 to CmdLine.NumFiles do begin
      MyState := InitState;
      fn := CmdLine.files[i];
      DefaultExt (fn, DefExt);
      if not exist (fn) then
         writeln ('File ''', fn, ''' does not exist.')
      else begin
         MyState.SourceName := fn;
         ProcessFile (MyState);
      end;
    end;
end.

