unit TexETdef;
   { Type definitions, initialization for TeXET and ETTeX.

     12 Feb 95 JCC  Modifications to allow use as filter.
     26 Mar 91 JCC  DefMaxLen = MaxMaxLen
     27 Jan 91 JCC  TranDollar added
     13 Jan 90 JCC  ET commands implemented
     11 Oct 90 JCC  \perp
      7 Sep 90 JCC  MinMaxLen = 20 to allow buffer.
      6 Sep 90 JCC  Reduce MaxMaxLen to 200, mods for continuation
      5 Sep 90 JCC  State --> Params.
      4 Sep 90 JCC  Improve fraction
      7 Aug 90 JCC  Setfrac case for fraction.
      2 Aug 90 JCC  Fraction support.  CSBksp and CSfrac here.
     15 Jun 90 JCC  Add Maxlen, minmaxlen and Maxmaxlen.
   }
{$I etdirect.inc}            {Directives shared by all units}

interface

uses utils, ETSyms;

Const
   BUFSIZE  = 10000;
   MaxBrace = 20;
   MinMaxLen= 20;     {Make sure we have room to do something}
   MaxMaxLen= 200;    {Make sure there is some room left over
                       for programs that use Turbo Pascal strings.}
   DefMaxLen= MaxMaxLen;
   EOFCh    = #26;
   ContinueStr = '%ET-';
   ContinueStr1 = '%ET_';
   CmdIntro = '%ET ';         {Introduces ET command.  Notice trailing ' '}

type
   ShortString = string[20];
   CSString = string[20];
   TextBuf = array[1..BUFSIZE] of char;
   CharSet = Set of Char;
   SubSupType = (normal, superscript, subscript, arg, getarg, setfrac);
      { These correspond to the types of nesting.  GetArg is
        a place holder on the Bracetype stack to indicate the need
        for extracting an argument. }
   Mode = (InMath, InEq, InText);
       {Commands are flagged by '%ET ' then a word.
        ETCmdBad => illegal keyword.  }
   ETCmdtype = (ETCmdNone, ETCmdCont, ETCmdBad, ETCmdTran, ETCmdNoTran);
   Params = record
              SourceName, DestName : FileName;
              MaxLen: integer;         { max. allowed len. of o/p line in ETTOTEX}
              TranDollar: boolean;     { Translate $ and $$ in TEXTOET}
              LogOutput: ^text;        {File to receive output messages}
           end;

const
   Letters : CharSet = ['A'..'Z', 'a'..'z'];

   CSBksp : CSString = '\llap';
   CSFrac : CSString = '\frac';

   GreekTrans : array[' '..#126] of CSString =
     ('~', '\hbar', '\sqrt', '\dalem', '\pound', '\equiv',                { $25}
     '\Pomeron', '\Reggeon', '\langle',                                 { $28}
     '\rangle', '\times', '\pm', '\nabla', '\mp', '\cdot', '\div',      { $2F}
     '\undef{0}', '\undef{1}', '\undef{2}', '\undef{3}',
     '\undef{4}', '\undef{5}',                                          { $35}
     '\undef{6}', '\undef{7}', '\undef{8}', '\undef{9}',                          { $39}
     '\undef{:}', '\undef{;}', '\leq', '\approx', '\geq',
     '\undef{?}',                                                       { $3F}
     '\circ', '\undef{A}', '\undef{B}', '\Psi', '\Delta',
     '\undef{E}',                                                       { $45}
     '\Phi', '\Gamma', '\undef{H}', '\undef{I}', '\partial',
     '\undef{K}',                                                       { $4B}
     '\Lambda', '\undef{M}', '\int', '\Omega',                          { $4F}
     '\prod', '\Chi', '\Rho', '\sum', '\perp', '\Upsilon', '\Theta', { $56}
     '\undef{W}', '\Xi', '\undef{Y}', '\undef{Z}', '\gets',
     '\undef{backslash}', '\to',                                        { $5D}
     '\infty', '\propto',                                               { $5F}
     '\ell', '\alpha', '\beta', '\psi', '\delta', '\epsilon',           { $65}
     '\phi', '\gamma', '\eta', '\iota', '\dagger', '\kappa',            { $6B}
     '\lambda', '\mu', '\nu', '\omega',                                 { $6F}
     '\pi', '\chi', '\rho', '\sigma', '\tau', '\upsilon', '\theta',     { $76}
     '\omega', '\xi', '\undef{y}', '\zeta', '\gets',
     '\undef{|}', '\to',                                                { $7D}
     '\undef{-}');                                                      { $7E}


procedure DefaultSettings (var MyParams : Params);


implementation (* ============ IMPLEMENTATION ======================= *)

procedure DefaultSettings (var MyParams : Params);
  begin
     with MyParams do begin
        MaxLen := DefMaxLen;
        TranDollar := true;
        LogOutput := @output;
     end;
  end;

(* ==================== INITIALIZATION ============================  *)
begin
end.

