package com.dickimawbooks.jmakepdfx;

import java.awt.*;
import java.io.*;
import java.awt.event.*;
import javax.swing.*;

public class PropertiesDialog extends JDialog
   implements ActionListener
{
   public PropertiesDialog(Jmakepdfx application)
   {
      super(application, application.getLabel("properties.title"), true);

      app = application;
      properties = app.getProperties();

      String defaultDir = properties.getDefaultDirectory();

      if (defaultDir == null)
      {
         defaultDir = ".";
      }

      File file = new File(defaultDir);

      String setting = properties.getDefaultDirectorySetting();

      if (setting == null)
      {
         setting = "home";
      }

      Box mainPanel = Box.createVerticalBox();
      mainPanel.setBorder(BorderFactory.createLoweredBevelBorder());

      mainPanel.setAlignmentX(Component.LEFT_ALIGNMENT);
      mainPanel.setAlignmentY(Component.CENTER_ALIGNMENT);

      Box startDirBox = Box.createVerticalBox();
      startDirBox.setAlignmentX(Component.LEFT_ALIGNMENT);
      startDirBox.setBorder(BorderFactory.createTitledBorder(
         BorderFactory.createEtchedBorder(),
         app.getLabel("properties.startup")));
      mainPanel.add(startDirBox);

      ButtonGroup bg = new ButtonGroup();

      homeButton = new JRadioButton(app.getLabel("properties.home"));
      homeButton.setActionCommand("disablecustom");
      homeButton.addActionListener(this);
      homeButton.setMnemonic(app.getMnemonic("properties.home"));
      homeButton.setAlignmentX(Component.LEFT_ALIGNMENT);
      homeButton.setAlignmentY(Component.CENTER_ALIGNMENT);
      bg.add(homeButton);
      startDirBox.add(homeButton);

      lastButton = new JRadioButton(app.getLabel("properties.last"));
      lastButton.setActionCommand("disablecustom");
      lastButton.setMnemonic(app.getMnemonic("properties.last"));
      lastButton.addActionListener(this);
      lastButton.setAlignmentX(Component.LEFT_ALIGNMENT);
      lastButton.setAlignmentY(Component.CENTER_ALIGNMENT);
      bg.add(lastButton);
      startDirBox.add(lastButton);

      Box box = Box.createHorizontalBox();
      box.setAlignmentX(Component.LEFT_ALIGNMENT);
      box.setAlignmentY(Component.TOP_ALIGNMENT);

      customButton = new JRadioButton(app.getLabel("properties.custom"));
      customButton.setMnemonic(app.getMnemonic("properties.custom"));
      customButton.setActionCommand("enablecustom");
      customButton.addActionListener(this);
      customButton.setAlignmentX(Component.LEFT_ALIGNMENT);
      customButton.setAlignmentY(Component.CENTER_ALIGNMENT);
      customButton.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
      bg.add(customButton);
      box.add(customButton);

      fileChooser = new JFileChooser();

      customField = new FileField(this, fileChooser, JFileChooser.DIRECTORIES_ONLY);
      box.add(customField);

      if (setting.equals("home"))
      {
         homeButton.setSelected(true);
         customField.setEnabled(false);
      }
      else if (setting.equals("last"))
      {
         homeButton.setSelected(true);
         customField.setEnabled(false);
      }
      else if (setting.equals("custom"))
      {
         customButton.setSelected(true);
         customField.setFileName(file.getAbsolutePath());
      }

      Dimension d = customField.getPreferredSize();
      d.width = (int)customField.getMaximumSize().getWidth();
      customField.setMaximumSize(d);

      startDirBox.add(box);

      mainPanel.add(new Box.Filler(
        new Dimension(0,0),
        new Dimension(1,20),
        new Dimension(1,Integer.MAX_VALUE)
      ));

      // File paths

      box = Box.createHorizontalBox();
      box.setAlignmentX(Component.LEFT_ALIGNMENT);

      JLabel gsLabel = new JLabel(app.getLabel("properties.path.gs"));
      gsLabel.setAlignmentY(Component.CENTER_ALIGNMENT);
      gsLabel.setDisplayedMnemonic(app.getMnemonic("properties.path.gs"));
      box.add(gsLabel);

      gsField = new FileField(this, properties.getGSApp(), fileChooser);
      gsLabel.setLabelFor(gsField.getTextField());
      box.add(gsField);

      mainPanel.add(box);

      box = Box.createHorizontalBox();
      box.setAlignmentX(Component.LEFT_ALIGNMENT);

      JLabel pdfLabel = new JLabel(app.getLabel("properties.path.pdfviewer"));
      pdfLabel.setAlignmentY(Component.CENTER_ALIGNMENT);
      pdfLabel.setDisplayedMnemonic(app.getMnemonic("properties.path.pdfviewer"));
      box.add(pdfLabel);

      pdfField = new FileField(this, properties.getPDFViewer(), fileChooser);
      pdfLabel.setLabelFor(pdfField.getTextField());
      box.add(pdfField);

      mainPanel.add(box);

      mainPanel.add(new Box.Filler(
        new Dimension(0,0),
        new Dimension(1,20),
        new Dimension(1,Integer.MAX_VALUE)
      ));

      Box iccBox = Box.createVerticalBox();
      iccBox.setBorder(BorderFactory.createTitledBorder(
         BorderFactory.createEtchedBorder(),
         "ICC"
      ));
      iccBox.setAlignmentX(Component.LEFT_ALIGNMENT);
      mainPanel.add(iccBox);

      box = Box.createHorizontalBox();
      box.setAlignmentX(Component.LEFT_ALIGNMENT);

      JLabel iccLabel = new JLabel(app.getLabel("properties.path.icc"));
      iccLabel.setAlignmentY(Component.CENTER_ALIGNMENT);
      iccLabel.setDisplayedMnemonic(app.getMnemonic("properties.path.icc"));
      box.add(iccLabel);

      iccField = new FileField(this, properties.getICCFile(), fileChooser);
      iccLabel.setLabelFor(iccField.getTextField());
      box.add(iccField);

      iccBox.add(box);

      iccBox.add(new Box.Filler(
        new Dimension(0,0),
        new Dimension(1,20),
        new Dimension(1,Integer.MAX_VALUE)
      ));

      box = Box.createHorizontalBox();
      box.setAlignmentX(Component.LEFT_ALIGNMENT);

      JTextArea textArea = new JTextArea(app.getLabel("properties.fetch_icc.info"));
      textArea.setAlignmentX(Component.LEFT_ALIGNMENT);
      textArea.setOpaque(false);
      textArea.setEditable(false);
      textArea.setLineWrap(true);
      textArea.setWrapStyleWord(true);

      box.add(textArea);

      fetchButton = new JButton(app.getLabel("properties.fetch_icc"));
      fetchButton.setMnemonic(app.getMnemonic("properties.fetch_icc"));
      fetchButton.setActionCommand("fetchicc");
      fetchButton.addActionListener(this);

      box.add(fetchButton);

      iccBox.add(box);

      mainPanel.add(new Box.Filler(
        new Dimension(0,0),
        new Dimension(1,20),
        new Dimension(1,Integer.MAX_VALUE)
      ));

      timeoutPanel = new NonNegativeLongPanel("properties.timeout", 
       properties.getMaxProcessTime()/60000L);
      timeoutPanel.setAlignmentX(Component.LEFT_ALIGNMENT);

      timeoutPanel.add(new JLabel(app.getLabel("properties.timeout.minutes")));

      timeoutPanel.add(new Box.Filler(
        new Dimension(0,0),
        new Dimension(40, 1),
        new Dimension(Integer.MAX_VALUE,1)
      ));

      mainPanel.add(timeoutPanel);

      mainPanel.add(new Box.Filler(
        new Dimension(0,0),
        new Dimension(1,20),
        new Dimension(1,Integer.MAX_VALUE)
      ));

      Dimension dim = mainPanel.getPreferredSize();

      dim.width += 30;
      dim.height += 30;

      mainPanel.setPreferredSize(dim);

      getContentPane().add(new JScrollPane(mainPanel), "Center");

      JPanel buttonPanel = new JPanel();
      getContentPane().add(buttonPanel, "South");

      buttonPanel.add(JpdfxResources.createOkayButton(this));
      buttonPanel.add(JpdfxResources.createCancelButton(this));

      JButton helpButton = new JButton(app.getLabel("button.help"));
      helpButton.setMnemonic(app.getMnemonic("button.help"));
      app.enableHelpOnButton(helpButton, "sec:settings");
      buttonPanel.add(helpButton);

      pack();
      setLocationRelativeTo(app);
   }

   public void display()
   {
      gsField.setFileName(properties.getGSApp());
      pdfField.setFileName(properties.getPDFViewer());
      iccField.setFileName(properties.getICCFile());
      timeoutPanel.setValue(properties.getMaxProcessTime()/60000L);

      setVisible(true);
   }

   public void actionPerformed(ActionEvent evt)
   {
      String action = evt.getActionCommand();

      if (action == null) return;

      if (action.equals("disablecustom"))
      {
         customField.setEnabled(false);
      }
      else if (action.equals("enablecustom"))
      {
         customField.setEnabled(true);
         customField.requestFocusInWindow();
      }
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
      else if (action.equals("fetchicc"))
      {
         try
         {
            File file = app.fetchICCFile();

            if (file != null)
            {
               iccField.setFileName(file.getAbsolutePath());
            }
         }
         catch (Exception e)
         {
            app.error(e);
         }
      }
      else if (action.equals("okay"))
      {
         properties.setGSApp(gsField.getFileName());
         properties.setPDFViewer(pdfField.getFileName());
         properties.setICCFile(iccField.getFileName());
         properties.setMaxProcessTime(timeoutPanel.getValue()*60000L);

         if (homeButton.isSelected())
         {
            properties.setDefaultHomeDir();
         }
         else if (lastButton.isSelected())
         {
            properties.setDefaultLastDir();
         }
         else
         {
            String fileName  = customField.getFileName();

            if (fileName.equals(""))
            {
               JpdfxResources.error(this, app.getLabel("error.prop.missing.custom"));
               return;
            }

            File file = new File(fileName);

            if (!file.isDirectory())
            {
               JpdfxResources.error(this,
                  app.getLabelWithValue("error.dir.not", fileName));
            }

            properties.setDefaultCustomDir(fileName);
         }
         
         setVisible(false);
      }
   }

   private Jmakepdfx app;
   private JpdfxProperties properties;

   private JFileChooser fileChooser;

   private JRadioButton homeButton, lastButton, customButton;

   private FileField customField, gsField, pdfField, iccField;

   private NonNegativeLongPanel timeoutPanel;

   private JButton fetchButton;
}
