/* l2xcom.h      typedefs, etc for ltx2x */

#ifndef L2XCOM_H
#define L2XCOM_H

#ifndef STRTYPES_H
#include "strtypes.h"
#endif

#ifndef common_h
typedef int ICT;           /* from inter code  common.h  */
#endif

typedef union u_rwc{
            int bfnum;  /* buffer or file number */
            FILE *uf;    /* file */
            STRING defstr;  /* string in CT */
            ICT *bytecode;  /* pointer to a compiled code segment */
           } URWC ;

typedef struct st_rwc{
             struct st_rwc *next;     /* pointer to next in list */
             int cmd;                 /* command keyword enum */
             int pcenum;              /* print_control enum */
             URWC  rwcode;            /* print_control value */
             } STRWC, *PSTRWC ;


typedef struct st_entry {           /* symbol table entry */
  STRING command;                   /* user defined command string */
  int kind;                         /* user defined kind of command */
  int parse_kind;                   /* system defined kind of command */
  int mode;                         /* mode for this command (if any) */
  struct st_entry *next_mode;       /* pointer to next mode */
  PSTRWC printing;                  /* print control (changed 6/96 from int) */
  PSTRWC command_t;                 /* command tag */
  PSTRWC command_et;                /* end of command tag */
  int numparams;                    /* user defined no. of required params */
  PSTRWC param_t[9];                /* parameter begin tags */
  PSTRWC param_et[9];               /* parameter end tags */
  PSTRWC print_param[9];    /* param text print control (changed 6/96 from int) */
  int opt_param_pos;                /* position (if any) of optional param */
  PSTRWC opt_param_t;               /* opt param begin tag */
  PSTRWC opt_param_et;              /* opt param end tag */
  PSTRWC popt_param_t[2];           /* (SD) first and last opt param begin tag */
  PSTRWC popt_param_et[2];          /* (SD) first and last opt param end tags */
  PSTRWC print_opt[2];      /* opt param text print control (changed 6/96 from int) */
  PSTRWC start_pc;                  /* starting print control (added 6/96) */
  PSTRWC end_pc;                    /* ending print control (added 6/96) */
  int sectioning_level;             /* user specified sectioning level */
  int special_token;                /* user defined special token for/from yac */
} STENTRY, *PSENTRY;

#define IERR -1

enum print_control{
#define kwtc(a, b) 
#define lctc(a, b)
#define pctc(a, b) a,
#include "l2xlibtc.h"
#undef kwtc
#undef lctc
#undef pctc
};

/*
enum print_control{BUFFER,
                   DEFAULT_PRINT,
                   FFILE,
                   FIRST_STRING,
                   MODE,
                   NO_OP,
                   NO_PRINT,
                   PRINT_UNDERFLOW,
                   RESET,
                   SOURCE_STRING,
                   SYSBUF,
                   TO_BUFFER,
                   TO_FILE,
                   TO_SYSBUF,
                   UNKNOWN_PRINT, 
                   MAX_PCSTR};
*/

#endif
