/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.os.FileQueueOperation;
import com.izforge.izpack.util.os.WinSetupFileQueue;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class FileQueueDelete
implements FileQueueOperation {
    private static final Logger logger = Logger.getLogger(FileQueueDelete.class.getName());
    protected File file;

    public FileQueueDelete(File file) {
        this.file = file;
    }

    public FileQueueDelete(String file) {
        this.file = new File(file);
    }

    @Override
    public void addTo(WinSetupFileQueue fileQueue) throws IOException {
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    logger.warning("Directory " + this.file.getAbsolutePath() + " cannot be removed in a file queue");
                } else {
                    logger.fine("Enqueueing deletion of " + this.file.getAbsolutePath());
                    try {
                        fileQueue.addDelete(this.file);
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to enqueue deletion of " + this.file + " due to " + ioe.getMessage();
                        throw new IOException(msg);
                    }
                }
            } else {
                logger.warning("Could not find file " + this.file.getAbsolutePath() + " to delete.");
            }
        }
    }
}

