/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.converters;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.Converters;
import org.picocontainer.converters.BooleanConverter;
import org.picocontainer.converters.ByteConverter;
import org.picocontainer.converters.CharacterConverter;
import org.picocontainer.converters.Converter;
import org.picocontainer.converters.DoubleConverter;
import org.picocontainer.converters.FileConverter;
import org.picocontainer.converters.FloatConverter;
import org.picocontainer.converters.IntegerConverter;
import org.picocontainer.converters.LongConverter;
import org.picocontainer.converters.ShortConverter;
import org.picocontainer.converters.UrlConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltInConverters
implements Converters,
Serializable {
    private final Map<Class<?>, Converter<?>> converters = new HashMap();

    public BuiltInConverters() {
        this.addBuiltInConverters();
    }

    protected void addBuiltInConverters() {
        this.addMultiTypeConverter(new IntegerConverter(), Integer.class, Integer.TYPE);
        this.addMultiTypeConverter(new DoubleConverter(), Double.class, Double.TYPE);
        this.addMultiTypeConverter(new BooleanConverter(), Boolean.class, Boolean.TYPE);
        this.addMultiTypeConverter(new LongConverter(), Long.class, Long.TYPE);
        this.addMultiTypeConverter(new FloatConverter(), Float.class, Float.TYPE);
        this.addMultiTypeConverter(new CharacterConverter(), Character.class, Character.TYPE);
        this.addMultiTypeConverter(new ByteConverter(), Byte.class, Byte.TYPE);
        this.addMultiTypeConverter(new ShortConverter(), Short.class, Short.TYPE);
        this.addConverter(new FileConverter(), File.class);
        this.addConverter(new UrlConverter(), URL.class);
    }

    private void addMultiTypeConverter(Converter<?> converter, Class<?> ... types) {
        for (Class<?> type : types) {
            this.addConverter(converter, type);
        }
    }

    protected void addConverter(Converter<?> converter, Class<?> key) {
        this.converters.put(key, converter);
    }

    @Override
    public boolean canConvert(Type type) {
        return this.converters.containsKey(type);
    }

    @Override
    public Object convert(String paramValue, Type type) {
        Converter<?> converter = this.converters.get(type);
        if (converter == null) {
            return null;
        }
        return converter.convert(paramValue);
    }
}

