/***************************/
/* dyn.h                   */
/***************************/

static int global;
static unsigned long uslonghelp;

/* the following array was built for detecting durations of notes       */
/* and avoids 1/32.. , 1/64. and 1/64.. notes                           */

static char halfresthigh[7] = { 5, 4, 3, 4, 4, 0, 0 };
static char resthigh[7] = { 11, 9, 7, 5, 7, 3, 3 };

char RESTTOLERANCE = 6;
char HALFRESTTOLERANCE = 2;

char UPPLOWSHIFT = 7;    /* 5 shift the position because of TeX */

static short loudarray[8] = { 10, 25, 40, 55, 75, 95, 115, 300 };

static double faktors[21] =
	{ 1, 1, 1, 2, 3, 3, 4, 6, 7, 8, 12, 14,
	 16, 24, 28, 32, 48, 56, 64, 96, 112 };

static int NORMFAKTOR = 16;
static short note_codes[21] =
	{ 0x0, 0x1, 0x2, 0x8, 0x9, 0xA, 0x10, 0x11, 0x12, 0x18, 0x19, 0x1A,
	  0x20, 0x21, 0x22, 0x28, 0x29, 0x2A, 0x30, 0x31, 0x32 };

/* the next arrays are for calculating the position of notes with their signs */
static int crosses[7] = { 5, 0, 7, 2, 9, 4, 11 };
static int bs[7] = { 11, 4, 9, 2, 7, 0, 5 };
static char process[12] = { 64, 0, 64, 0, 64, 64, 0, 64, 0, 64, 0, 64 };
static char pitch_to_pos[12] = { 0, 0, 1, 0, 2, 3, 0, 4, 0, 5, 0, 6 };
char positions[42] = {
	'C', 'D', 'E', 'F', 'G', 'A', 'B',
	'C', 'D', 'E', 'F', 'G', 'H', 'I',
	'J', 'K', 'L', 'M', 'N', 'a', 'b',
	'c', 'd', 'e', 'f', 'g', 'h', 'i',
	'j', 'k', 'l', 'm', 'n', 'o', 'p',
	'q', 'r', 's', 't', 'u', 'v', 'w' };

static char LAMBDA = 9;		/* maximal length of normal stems (1/64 note) */
static char BEAMDELTA = 19;     /* maximal length of beamed stems */
static char BEAMTOLERANCE = 7;  /* 7 minimal distance between beamed notes and the beam itself */
static char BEAMTOLMAX = 12;    /* 11 maximal distance between beamed notes and the beam itself */
static char SLURWIDE = 4;       /* vertical wide of slurs */
static char MINBEAMBROAD = 5;	/* minimal distance between the highest and the lowest note for middle beams */
static char BASSMID = 15;       /* middle position of bass clef */
static char VIOLINEMID = 27;    /* middle position of violine clef */
static char SLOPEFACTOR = 5;    /* 3 for the slope of beams - smaller SLOPEFACTOR means bigger slopes */

static struct bind *prev[MAXTRACKS], *remember[MAXTRACKS];
static struct bind *bp, *dy, *dy2, *d, *d2, *d3;
static struct bind *dynhelp2, *dynhelp3;
struct bind *begin[MAXTRACKS], *akt[MAXTRACKS], *dynhelp;

static struct Barre {           /* 'b' */
	short number_of_voices;
	int takt_duration;
} *bar;

struct loudrec {        /* for storing some loudness datas */
	unsigned long time;
	unsigned short criterium;
	char range;
} *loudrecarr[6];

int modulo4pp[6] = { 1, 2, 3, 4, 5, 0 };

struct KeySig *ks;
struct Lyric *ly;
struct TimeSig *ts;
static struct Note *not2, *not3;
struct Note *not;
struct Rest *re;
struct Loudness *lo;

static struct helprest {
	unsigned long begin;
	unsigned long end;
	struct helprest *next;
} *ank, *hr1, *hr2, *hr3, *hres1, *hres2, *hres3;

