/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.text;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PDFTextStripperByArea
extends PDFTextStripper {
    private final List<String> regions = new ArrayList<String>();
    private final Map<String, Rectangle2D> regionArea = new HashMap<String, Rectangle2D>();
    private final Map<String, Vector<List<TextPosition>>> regionCharacterList = new HashMap<String, Vector<List<TextPosition>>>();
    private final Map<String, StringWriter> regionText = new HashMap<String, StringWriter>();

    public PDFTextStripperByArea() throws IOException {
        super.setShouldSeparateByBeads(false);
    }

    @Override
    public void setShouldSeparateByBeads(boolean aShouldSeparateByBeads) {
    }

    public void addRegion(String regionName, Rectangle2D rect) {
        this.regions.add(regionName);
        this.regionArea.put(regionName, rect);
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public String getTextForRegion(String regionName) {
        StringWriter text = this.regionText.get(regionName);
        return text.toString();
    }

    public void extractRegions(PDPage page) throws IOException {
        Iterator<String> regionIter = this.regions.iterator();
        while (regionIter.hasNext()) {
            this.setStartPage(this.getCurrentPageNo());
            this.setEndPage(this.getCurrentPageNo());
            String regionName = regionIter.next();
            Vector regionCharactersByArticle = new Vector();
            regionCharactersByArticle.add(new ArrayList());
            this.regionCharacterList.put(regionName, regionCharactersByArticle);
            this.regionText.put(regionName, new StringWriter());
        }
        if (page.hasContents()) {
            this.processPage(page);
        }
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        for (String region : this.regionArea.keySet()) {
            Rectangle2D rect = this.regionArea.get(region);
            if (!rect.contains(text.getX(), text.getY())) continue;
            this.charactersByArticle = this.regionCharacterList.get(region);
            super.processTextPosition(text);
        }
    }

    @Override
    protected void writePage() throws IOException {
        for (String region : this.regionArea.keySet()) {
            this.charactersByArticle = this.regionCharacterList.get(region);
            this.output = this.regionText.get(region);
            super.writePage();
        }
    }
}

