/*
 * Decompiled with CFR 0.152.
 */
package pdbf.tests;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import pdbf.PDBF_Compiler;
import pdbf.misc.Tools;

public class CompileAndCheckIT {
    @Rule
    public TimeTestWatcher watcher = new TimeTestWatcher();
    public static String baseDir;
    public static String testDir;
    public static String refDir;

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ERROR);
        baseDir = Tools.getBaseDir();
        testDir = String.valueOf(baseDir) + "src" + File.separator + "pdbf" + File.separator + "tests" + File.separator;
        refDir = String.valueOf(baseDir) + "referenceImages" + File.separator;
    }

    public static void compareImages(BufferedImage i1, BufferedImage i2) {
        int height = i1.getHeight();
        int width = i1.getWidth();
        if (height != i2.getHeight()) {
            Assert.fail("Failed! Height of picture does not match height of the reference picture");
        }
        if (width != i2.getWidth()) {
            Assert.fail("Failed! Width of picture does not match width of the reference picture");
        }
        int sum = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color1 = i1.getRGB(x, y);
                int color2 = i2.getRGB(x, y);
                int r1 = (color1 & 0xFF0000) >> 16;
                int r2 = (color2 & 0xFF0000) >> 16;
                int g1 = (color1 & 0xFF00) >> 8;
                int g2 = (color2 & 0xFF00) >> 8;
                int b1 = color1 & 0xFF;
                int b2 = color2 & 0xFF;
                sum += Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
                ++x;
            }
            ++y;
        }
        double n = width * height * 3;
        double p = (double)sum / n / 255.0;
        System.out.println((double)Math.round(p * 10000.0) / 100.0 + "%");
        double errorThreshold = 0.03;
        if (p >= errorThreshold) {
            Assert.fail("Failed! Too much difference to reference picture");
        }
    }

    public static void compile(String texDir, String texName) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("java", "-jar", String.valueOf(baseDir) + "pdbf.jar", texName);
        pb.directory(new File(texDir));
        pb.inheritIO();
        Process p = pb.start();
        p.waitFor();
        if (p.exitValue() != 0) {
            Assert.fail("PDBF compiler exited with error!");
        }
    }

    public static void compareImages(String jsName, String htmlDir, String htmlName) throws IOException, InterruptedException {
        String name;
        Object file;
        Tools.processes.clear();
        Tools.deleteList.clear();
        File dir = new File(baseDir);
        Object object = dir.listFiles();
        int n = ((File[])object).length;
        int n2 = 0;
        while (n2 < n) {
            file = object[n2];
            name = ((File)file).getName();
            if (name.startsWith(htmlName) && name.endsWith(".png")) {
                ((File)file).delete();
            }
            ++n2;
        }
        Tools.runJsFile(jsName, htmlDir, htmlName, baseDir);
        for (Process p : Tools.processes) {
            p.waitFor();
            if (p.exitValue() == 0) continue;
            for (Process p2 : Tools.processes) {
                p2.destroy();
            }
            Assert.fail("Phantomjs exited with error!");
        }
        for (File f : Tools.deleteList) {
            f.delete();
        }
        object = dir.listFiles();
        n = ((File[])object).length;
        int n3 = 0;
        while (n3 < n) {
            file = object[n3];
            name = ((File)file).getName();
            if (name.startsWith(htmlName) && name.endsWith(".png")) {
                BufferedImage i1 = ImageIO.read((File)file);
                BufferedImage i2 = ImageIO.read(new File(String.valueOf(refDir) + name));
                System.out.print(String.valueOf(((File)file).getName()) + " error percentage: ");
                CompileAndCheckIT.compareImages(i1, i2);
                ((File)file).delete();
            }
            ++n3;
        }
    }

    public static void checkHTML(String htmlDir, String htmlName) throws IOException, InterruptedException {
        CompileAndCheckIT.compareImages("capturePages.js", htmlDir, htmlName);
        CompileAndCheckIT.compareImages("captureOverlays.js", htmlDir, htmlName);
    }

    public static void checkPDF(String pdfDir, String pdfName) throws IOException {
        ValidationResult result = null;
        FileDataSource fd = new FileDataSource(String.valueOf(pdfDir) + pdfName);
        PreflightParser parser = new PreflightParser((DataSource)fd);
        try {
            parser.parse();
            PreflightDocument document = parser.getPreflightDocument();
            result = document.getResult();
            document.close();
        }
        catch (SyntaxValidationException e) {
            result = e.getResult();
        }
        if (result.isValid()) {
            System.out.println("Finished checkPDF successfully");
        } else {
            System.err.println("The file is not valid, error(s) :");
            for (ValidationResult.ValidationError error : result.getErrorsList()) {
                System.err.println(String.valueOf(error.getErrorCode()) + " : " + error.getDetails());
                Assert.fail(String.valueOf(error.getErrorCode()) + " : " + error.getDetails());
            }
            Assert.fail("PDF file not valid, but no validation error was output");
        }
    }

    public static void checkTAR(String tarDir, String tarName) throws IOException {
        String tarFile = String.valueOf(tarDir) + tarName;
        TarArchiveInputStream tis = new TarArchiveInputStream(new BufferedInputStream(new FileInputStream(tarFile)));
        while (tis.getNextEntry() != null) {
            byte[] data = new byte[8192];
            while (tis.read(data) != -1) {
            }
        }
        tis.close();
        System.out.println("Finished checkTAR successfully");
    }

    public static void documentTest(String baseDir, String baseName, boolean withVM) throws IOException, InterruptedException {
        File f = new File(String.valueOf(baseDir) + baseName + ".html");
        File f2 = new File(String.valueOf(baseDir) + baseName + ".pdf");
        File f3 = new File(String.valueOf(baseDir) + baseName + ".ova");
        f.delete();
        f2.delete();
        f3.delete();
        CompileAndCheckIT.compile(baseDir, String.valueOf(baseName) + ".tex");
        if (!f.exists()) {
            Assert.fail("Compile failed");
        }
        if (withVM) {
            ProcessBuilder pb = new ProcessBuilder("java", "-jar", String.valueOf(baseDir) + "pdbf.jar", "--vm", String.valueOf(baseDir) + baseName + ".html", String.valueOf(CompileAndCheckIT.baseDir) + "vldb-Invaders.ova");
            pb.directory(new File(baseDir));
            pb.inheritIO();
            Process p = pb.start();
            p.waitFor();
            if (p.exitValue() != 0) {
                Assert.fail("PDBF compiler exited with error!");
            }
            f.delete();
            FileUtils.moveFile(f3, f);
        }
        CompileAndCheckIT.checkHTML(baseDir, String.valueOf(baseName) + ".html");
        FileUtils.moveFile(f, f2);
        CompileAndCheckIT.checkPDF(baseDir, String.valueOf(baseName) + ".pdf");
        FileUtils.moveFile(f2, f);
        new File(String.valueOf(baseDir) + ".aux").delete();
        new File(String.valueOf(baseDir) + ".log").delete();
        new File(String.valueOf(baseDir) + ".out").delete();
        new File(String.valueOf(baseDir) + ".toc").delete();
    }

    @Test(timeout=1800000L)
    public void documentation() throws IOException, InterruptedException {
        CompileAndCheckIT.documentTest(baseDir, "pdbf-doc", true);
        CompileAndCheckIT.checkTAR(baseDir, "pdbf-doc.html");
    }

    @Test(timeout=1800000L)
    public void minimal() throws IOException, InterruptedException {
        CompileAndCheckIT.documentTest(baseDir, "minimal", false);
    }

    @Test(timeout=1800000L)
    public void charts() throws IOException, InterruptedException {
        CompileAndCheckIT.documentTest(testDir, "charts", false);
    }

    @Test(timeout=1800000L)
    public void noPDBF() throws IOException, InterruptedException {
        CompileAndCheckIT.documentTest(testDir, "no_pdbf", false);
        new File(String.valueOf(testDir) + "no_pdbf.html").delete();
        new File(String.valueOf(testDir) + "pdbf.sty").delete();
        new File(String.valueOf(testDir) + "dummy.pdf").delete();
    }

    @Test(timeout=1800000L)
    public void compileOtherDir() throws IOException, InterruptedException {
        String otherFolder = String.valueOf(baseDir) + "otherFolder" + File.separator;
        new File(otherFolder).mkdirs();
        FileUtils.copyFile(new File(String.valueOf(baseDir) + "minimal.tex"), new File(String.valueOf(otherFolder) + "minimal.tex"));
        CompileAndCheckIT.documentTest(otherFolder, "minimal", false);
        if (!new File(String.valueOf(otherFolder) + "minimal.html").exists()) {
            Assert.fail("Compile failed");
        }
        FileUtils.deleteDirectory(new File(otherFolder));
    }

    public class TimeTestWatcher
    extends TestWatcher {
        private long startTime;

        @Override
        protected void starting(Description description) {
            System.out.println("Starting test: " + description.getMethodName());
            this.startTime = System.currentTimeMillis();
            if (!PDBF_Compiler.includeRes) {
                System.out.println("Test failed because includeRes is off!");
                Assert.fail();
            }
        }

        @Override
        protected void finished(Description description) {
            long elapsed = System.currentTimeMillis() - this.startTime;
            String testName = description.getMethodName();
            System.out.println(String.format("Test %s took %d ms.", testName, elapsed));
        }
    }
}

