/*
 * Decompiled with CFR 0.152.
 */
package pdbf.tests;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import pdbf.misc.Tools;
import pdbf.tests.CompileAndCheckIT;

public class CreateReferencePictures {
    public static String baseDir = Tools.getBaseDir();
    public static String refDir = String.valueOf(baseDir) + "referenceImages" + File.separator;
    public static String testDir = String.valueOf(baseDir) + "src" + File.separator + "pdbf" + File.separator + "tests" + File.separator;
    public static String suffix = Tools.getOS();

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            Logger.getRootLogger().setLevel(Level.ERROR);
            String[] documents = new String[]{"charts", "pdbf-doc", "minimal", "no_pdbf"};
            String[] documentsDir = new String[]{testDir, baseDir, baseDir, testDir};
            int i = 0;
            while (i < documents.length) {
                CompileAndCheckIT.compile(documentsDir[i], String.valueOf(documents[i]) + ".tex");
                Tools.runJsFile("capturePages.js", documentsDir[i], String.valueOf(documents[i]) + ".html", refDir);
                Tools.runJsFile("captureOverlays.js", documentsDir[i], String.valueOf(documents[i]) + ".html", refDir);
                ++i;
            }
            for (Process p : Tools.processes) {
                p.waitFor();
                if (p.exitValue() == 0) continue;
                throw new IllegalStateException("Phantomjs exited with error!");
            }
            for (File f : Tools.deleteList) {
                f.delete();
            }
            new File(String.valueOf(testDir) + "no_pdbf.aux").delete();
            new File(String.valueOf(testDir) + "no_pdbf.log").delete();
            new File(String.valueOf(testDir) + "no_pdbf.html").delete();
            new File(String.valueOf(testDir) + "charts.html").delete();
            String[] stringArray = new File(testDir).list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (Pattern.matches("Overlay\\d+(Tmp|).(pdf|json|data)", s)) {
                    new File(String.valueOf(testDir) + s).delete();
                }
                ++n2;
            }
            stringArray = new File(baseDir).list();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (Pattern.matches("Overlay\\d+(Tmp|).(pdf|json|data)", s)) {
                    new File(String.valueOf(baseDir) + s).delete();
                }
                ++n2;
            }
            new File(String.valueOf(testDir) + "dummy.pdf").delete();
            new File(String.valueOf(testDir) + "pdbf.sty").delete();
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

