#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#

#
#    man_srl.awk -- create a list of `search and replace' items for manually
#    converting citations in the wordprocessor
#    
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f man_sr.awk textfile
#
#    Versions:
#    31.7.2005: name of `outfle' may be changed (for References v4.2)
#

BEGIN {
  a = ""
  if (!output_file)
  {
    outfle = "msrl-mak.txt"
  } else
  {
    outfle=output_file
  }
}
{
  a = $0;
  gsub(/\/\/\/A\/\/\//,"",a) 
  gsub(/\/\/\/B\/\/\//,"\n",a)
  gsub(/\/\/\/C\/\/\//,"\ndone:\n",a)
  print a > outfle
}

END {
  print "\nManual search and replace list/macro " outfle " created\n"
  close(outfle)
}

