#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#

#
#    msw_sr.awk -- create a macro for converting citations in Word for
#    Windows
#
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f msw_sr.awk textfile
#
#    Versions:
#    30.7.2005: name of `outfle' may be changed (for References v4.2)
#
#
#    The following lines show a macro replacing the string "to-be-found" by
#    "to-be-inserted":


#    Selection.HomeKey Unit:=wdStory
#    Selection.Find.ClearFormatting
#    Selection.Find.Replacement.ClearFormatting
#    With Selection.Find
#        .Text = "to-be-found"
#        .Replacement.Text = "to-be-inserted"
#        .Forward = True
#        .Wrap = wdFindContinue
#        .Format = False
#        .MatchCase = False
#        .MatchWholeWord = False
#        .MatchWildcards = False
#        .MatchSoundsLike = False
#        .MatchAllWordForms = False
#    End With
#    Selection.Find.Execute Replace:=wdReplaceAll




BEGIN {
   a = ""
   if (!output_file)
   {
     outfle = "msw-mak.txt"
   } else
   {
     outfle=output_file
   }
}

{
  a = $0;
  gsub(/\/\/\/A\/\/\//,"    Selection.HomeKey Unit:=wdStory\n    Selection.Find.ClearFormatting\n    Selection.Find.Replacement.ClearFormatting\n    With Selection.Find\n        .Text = \"",a) 
  gsub(/\/\/\/B\/\/\//,"\"\n        .Replacement.Text = \"",a)
  gsub(/\/\/\/C\/\/\//,"\"\n        .Forward = True\n        .Wrap = wdFindContinue\n        .Format = False\n        .MatchCase = False\n        .MatchWholeWord = False\n        .MatchWildcards = False\n        .MatchSoundsLike = False\n        .MatchAllWordForms = False\n    End With\n    Selection.Find.Execute Replace:=wdReplaceAll",a)
  print a > outfle
}

END {
  print "\nMS-Word macro " outfle " created\n"
  close(outfle)
}

# vim:tw=2048

