#ifndef RUNTEX_FILESTUFF_H
#define RUNTEX_FILESTUFF_H

enum RUNTEX_FILE_TYPES_ENUM
{/* Nothing special about those */
/* -- TeX needs to be run again */
	TABLE_CONTENTS,
	LIST_FIGURES,
	LIST_TABLES,
	LIST_ALGORITHMS,
	BACK_REF,
	THEOREMS_STY,
	LISTINGS_STY,
	HYPERREF_STY,
/* have a number after their suffix */
/* -- need 2 TeX runs ? */
	MINI_TOC,
	MINI_LOF,
	MINI_LOT,
	MINI_PART_TOC,
	MINI_PART_LOF,
	MINI_PART_LOT,
	MINI_SECTION_TOC,
	MINI_SECTION_LOF,
	MINI_SECTION_LOT,
/* external util needs to be run */
/* -- 1 run */
	INDEX_FILE,
	GLOSSARY_FILE,
/* -- needs at least two TeX runs after util was executed */
	BIBLIOGRAPHY,
/* -- these are the only two currently whose file name may be
		different from the .tex file's, 1 TeX run */
	METAPOST_FILE,
	METAFONT_FILE,
/* just so it's easier to define the array */
	NUMBER_RUNTEX_FILE_TYPES
};

#define NUMBER_RUNTEX_FIRST_UTIL_SUFFIX INDEX_FILE

typedef struct
{
	char* suffix;
	int found;
} RUNTEX_FILE_TYPES;

RUNTEX_FILE_TYPES file_types[NUMBER_RUNTEX_FILE_TYPES]=
{/* temps from tex directly: .log, *.aux */
	{"toc",0},
	{"lof",0},
	{"lot",0},
	{"loa",0},
	{"brf",0},
	{"thm",0},
	{"lol",0},
	{"out",0},
	{"mtc*",0},
	{"mlf*",0},
	{"mlt*",0},
	{"ptc*",0},
	{"plf*",0},
	{"plt*",0},
	{"stc*",0},
	{"slf*",0},
	{"slt*",0},
	{"idx",0},/* temps [makeindex](xindy): .idx, .ind[, .ilg](, .raw, .sta, .xdy) */
	{"glo",0},/* temps [makeindex]: .glo, .gls[, .ilg] */
/* search for \citation{... in .aux is only way to detect need for BibTeX */
	{"bib",0},/* temps: .blg (log file), .bbl */
	{"mp",0},/* no temps */
	{"mf",0}/* no temps */
};


/* returns 0 on error */
int run_external_program(int exe_type, int file_type, char* file_name);
/* searches for the various files+suffix variations and increases
	counter/executes utils if necessary
	exits if error while running external program encountered */
void process_document_related_files(char* path_name);
/* returns full path to new directory, if successful; */
char* create_temp_dir(void);
/* creates a randomly named sub-directory in path and returns its name */
char* create_random_dir(char* path);
/* move all files to an other directory, overwriting existing files
	args: src_path = source directory
			files = string of the files to move
			dest_path = destination directory
	returns: 0 = error
				1 = success */
int move_files(char* src_path, char* files, char* dest_path);
/* delete all files that match expression */
int delete_files(char* path);
/* copies a text file */
int copy_file_to(char* src, char* dest);
/* deletes temporary files created by TeX and/or utils */
void delete_temporary_tex_files(char* path_name);

#endif
