let version () =
  print_string "This is Syngen version 0.4 (c) Jens Kloecker 1996.\n";
  flush stdout

let box_con = ref 8.
and box_off = ref 10.5
and char_off = ref 5.24995
and box_height = ref 14.
and box_sep_frac = ref 0.5

let update loc x = loc := x

let speclist = [("-c", Arg.Float (update box_con));
                ("-a", Arg.Float (update box_off));
                ("-o", Arg.Float (update char_off));
                ("-h", Arg.Float (update box_height));
                ("-f", Arg.Float (update box_sep_frac));
                ("-version", Arg.Unit version)]

let file_with_syn s = 
  if Filename.check_suffix s "ara" then 
    Filename.chop_suffix s "ara" ^ "syn"
  else s ^ ".syn"

let main s =
 try
  let in_file = open_in s
  and out_file = open_out (file_with_syn s) 
  and init_tex =
   "\\def\\ifundefined#1{\\expandafter\\ifx\\csname#1\\endcsname\\relax}%\n" ^
   "\\ifundefined{bdepth}\\newlength{\\bdepth}\\else\\relax\\fi%\n" ^
   "\\settodepth{\\bdepth}{\\ttfamily g}%\n" ^
   "\\ifundefined{bheight}\\newlength{\\bheight}\\else\\relax\\fi%\n" ^
   "\\settoheight{\\bheight}{\\ttfamily (}%\n"
  in 
    output_string out_file init_tex;
    Picture.output out_file (
      Latexcode.generate !box_con !box_off !char_off !box_height !box_sep_frac (
        Boxes.of_syntree !box_con !box_off !char_off !box_height !box_sep_frac (
          Parser.analyse (Stream.of_channel in_file)
        )
      )
    );
    close_in in_file;
    close_out out_file
 with Sys_error t -> print_string t; print_newline ()
    | Stream.Parse_error t -> print_string "Syntax error in file: ";
                              print_string s; print_newline ()
    | Stream.Parse_failure -> print_string "Syntax error in file: ";
                              print_string s; print_newline ()
;;

Arg.parse speclist (Printexc.print main)
