/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.actions.InputQueryDialog;
import net.sourceforge.texlipse.templates.ProjectTemplateManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class SaveAsTemplateAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private IWorkbenchWindow window;
    private IEditorPart editor;

    public void run(IAction action) {
        IFile file = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        String fullname = file.getFullPath().toString();
        InputQueryDialog dialog = new InputQueryDialog(this.editor.getEditorSite().getShell(), TexlipsePlugin.getResourceString("templateSaveDialogTitle"), TexlipsePlugin.getResourceString("templateSaveDialogMessage").replaceAll("%s", fullname), file.getName().substring(0, file.getName().lastIndexOf(46)), new IInputValidator(){

            public String isValid(String newText) {
                if (newText != null && newText.length() > 0) {
                    return null;
                }
                return TexlipsePlugin.getResourceString("templateSaveErrorFileName");
            }
        });
        if (dialog.open() == 0) {
            String newName = dialog.getInput();
            boolean reallySave = true;
            if (ProjectTemplateManager.templateExists(newName)) {
                reallySave = MessageDialog.openConfirm((Shell)this.editor.getSite().getShell(), (String)TexlipsePlugin.getResourceString("templateSaveOverwriteTitle"), (String)TexlipsePlugin.getResourceString("templateSaveOverwriteText").replaceAll("%s", newName));
            }
            if (reallySave) {
                ProjectTemplateManager.saveProjectTemplate(file, newName);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
        action.setEnabled(this.editor instanceof ITextEditor);
    }
}

