/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexCompletionProposal;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.model.TexCommandEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class TexInsertMathSymbolAction
extends Action {
    TexCommandEntry entry;
    TexEditor editor;

    public TexInsertMathSymbolAction(TexCommandEntry entry) {
        this.entry = entry;
        this.setText(entry.key);
        this.setToolTipText(entry.info);
        this.setImageDescriptor(entry.imageDesc);
    }

    public void run() {
        if (this.editor == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        TexCompletionProposal prop = new TexCompletionProposal(this.entry, selection.getOffset() + 1, 0, this.editor.getViewer());
        try {
            doc.replace(selection.getOffset(), 0, "\\");
            prop.apply(doc);
            int newOffset = selection.getOffset() + this.entry.key.length() + 1;
            if (this.entry.arguments > 0) {
                ++newOffset;
            }
            this.editor.getSelectionProvider().setSelection((ISelection)new TextSelection(newOffset, 0));
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("Error while trying to insert command", e);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        this.editor = part instanceof TexEditor ? (TexEditor)part : null;
    }
}

