/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.bibeditor.BibContentProvider;
import net.sourceforge.texlipse.bibeditor.BibLabelProvider;
import net.sourceforge.texlipse.bibparser.BibOutlineContainer;
import net.sourceforge.texlipse.extension.BibOutlineActionProvider;
import net.sourceforge.texlipse.model.ReferenceEntry;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class BibOutlinePage
extends ContentOutlinePage {
    public static final String SEGMENTS = "__bib_segments";
    private static final String ACTION_BYAUTHOR = "byauthor";
    private static final String ACTION_BYJOURNAL = "byjournal";
    private static final String ACTION_BYINDEX = "byindex";
    private static final String ACTION_BYYEAR = "byyear";
    private static final String ACTION_OPENBIBREF = "openbibref";
    protected BibOutlineContainer content;
    protected String sortBy;
    protected ITextEditor editor;
    private HashMap outlineActions = new HashMap();
    private List<Action> extensionActions;

    public BibOutlinePage(ITextEditor textEditor) {
        this.editor = textEditor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createActions();
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new BibContentProvider(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput())));
        viewer.setLabelProvider((IBaseLabelProvider)new BibLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.createToolbar();
        this.createContextMenu();
        if (this.content != null) {
            viewer.setInput((Object)this.content);
        }
    }

    public void update(BibOutlineContainer content) {
        Control control;
        this.content = content;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput((Object)this.content);
            control.setRedraw(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            try {
                ReferenceEntry be = (ReferenceEntry)((IStructuredSelection)selection).getFirstElement();
                Position position = be.position;
                this.editor.setHighlightRange(position.getOffset(), position.getLength(), true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.editor.resetHighlightRange();
            }
            catch (ClassCastException classCastException) {
                this.editor.resetHighlightRange();
            }
            catch (NullPointerException nullPointerException) {
                this.editor.resetHighlightRange();
            }
        }
    }

    private void createActions() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("net.sourceforge.texlipse.BibEditorOutlineExtension");
        if (config.length > 0) {
            this.extensionActions = new ArrayList<Action>();
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                try {
                    BibOutlineActionProvider a = (BibOutlineActionProvider)elem.createExecutableExtension("OutlineActionProvider");
                    IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
                    this.extensionActions.add(a.getAction(this.getTreeViewer(), resource));
                }
                catch (CoreException coreException) {}
                ++n2;
            }
        }
        Action byAuthor = new Action("Sort by Author", 8){

            public void run() {
                if (this.isChecked()) {
                    BibOutlineContainer newContent = ((BibContentProvider)BibOutlinePage.this.getTreeViewer().getContentProvider()).changeSort("author");
                    BibOutlinePage.this.update(newContent);
                }
            }
        };
        byAuthor.setToolTipText("Sort by Author");
        byAuthor.setImageDescriptor(TexlipsePlugin.getImageDescriptor("sortauthor"));
        this.outlineActions.put(ACTION_BYAUTHOR, byAuthor);
        Action byJournal = new Action("Sort by Journal", 8){

            public void run() {
                if (this.isChecked()) {
                    BibOutlineContainer newContent = ((BibContentProvider)BibOutlinePage.this.getTreeViewer().getContentProvider()).changeSort("journal");
                    BibOutlinePage.this.update(newContent);
                }
            }
        };
        byJournal.setToolTipText("Sort by Journal");
        byJournal.setImageDescriptor(TexlipsePlugin.getImageDescriptor("sortjournal"));
        this.outlineActions.put(ACTION_BYJOURNAL, byJournal);
        Action byIndex = new Action("Sort by Index", 8){

            public void run() {
                if (this.isChecked()) {
                    BibOutlineContainer newContent = ((BibContentProvider)BibOutlinePage.this.getTreeViewer().getContentProvider()).changeSort("index");
                    BibOutlinePage.this.update(newContent);
                }
            }
        };
        byIndex.setToolTipText("Sort by Index");
        byIndex.setImageDescriptor(TexlipsePlugin.getImageDescriptor("sortindex"));
        this.outlineActions.put(ACTION_BYINDEX, byIndex);
        Action byYear = new Action("Sort by Year", 8){

            public void run() {
                if (this.isChecked()) {
                    BibOutlineContainer newContent = ((BibContentProvider)BibOutlinePage.this.getTreeViewer().getContentProvider()).changeSort("year");
                    BibOutlinePage.this.update(newContent);
                }
            }
        };
        byYear.setToolTipText("Sort by Year");
        byYear.setImageDescriptor(TexlipsePlugin.getImageDescriptor("sortyear"));
        this.outlineActions.put(ACTION_BYYEAR, byYear);
        Action openBibRef = new Action("View reference", 1){

            public void run() {
                Object selectedElement;
                TreeItem[] ti = BibOutlinePage.this.getTreeViewer().getTree().getSelection();
                if (ti != null && (selectedElement = ti[0].getData()) instanceof ReferenceEntry) {
                    ReferenceEntry cfr_ignored_0 = (ReferenceEntry)selectedElement;
                }
            }
        };
        openBibRef.setToolTipText("Open the current reference in an external viewer");
        this.outlineActions.put(ACTION_OPENBIBREF, openBibRef);
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.outlineActions.get(ACTION_BYINDEX));
        toolbarManager.add((IAction)this.outlineActions.get(ACTION_BYAUTHOR));
        toolbarManager.add((IAction)this.outlineActions.get(ACTION_BYJOURNAL));
        toolbarManager.add((IAction)this.outlineActions.get(ACTION_BYYEAR));
        if (this.extensionActions != null) {
            for (Action a : this.extensionActions) {
                toolbarManager.add((IAction)a);
            }
        }
    }

    private void fillContextMenu(IMenuManager mgr) {
        Object selectedElement;
        TreeItem[] ti = this.getTreeViewer().getTree().getSelection();
        if (ti != null && ti.length > 0 && (selectedElement = ti[0].getData()) instanceof ReferenceEntry && ((ReferenceEntry)selectedElement).refFile != null) {
            mgr.add((IAction)this.outlineActions.get(ACTION_OPENBIBREF));
        }
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                BibOutlinePage.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
    }
}

