/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.texlipse.PathUtils;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderCoreException;
import net.sourceforge.texlipse.builder.ExternalProgram;
import net.sourceforge.texlipse.builder.ProgramRunner;
import net.sourceforge.texlipse.builder.TexlipseBuilder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.texteditor.MarkerUtilities;

public abstract class AbstractProgramRunner
implements ProgramRunner {
    private ExternalProgram extrun = new ExternalProgram();

    protected AbstractProgramRunner() {
    }

    private String getArgumentsPreferenceName() {
        return this.getClass() + "_args";
    }

    private String getCommandPreferenceName() {
        return this.getClass() + "_prog";
    }

    public String getProgramPath() {
        return TexlipsePlugin.getPreference(this.getCommandPreferenceName());
    }

    public void setProgramPath(String path) {
        TexlipsePlugin.getDefault().getPreferenceStore().setValue(this.getCommandPreferenceName(), path);
    }

    public String getProgramArguments() {
        return TexlipsePlugin.getPreference(this.getArgumentsPreferenceName());
    }

    public void setProgramArguments(String args) {
        TexlipsePlugin.getDefault().getPreferenceStore().setValue(this.getArgumentsPreferenceName(), args);
    }

    public void initializeDefaults(IPreferenceStore pref, String path) {
        pref.setDefault(this.getCommandPreferenceName(), path);
        pref.setDefault(this.getArgumentsPreferenceName(), this.getDefaultArguments());
    }

    protected String getDefaultArguments() {
        return "%input";
    }

    public String getProgramName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") >= 0) {
            return this.getWindowsProgramName();
        }
        return this.getUnixProgramName();
    }

    protected abstract String getWindowsProgramName();

    protected abstract String getUnixProgramName();

    protected String getArguments(IResource resource) {
        String args = this.getProgramArguments();
        if (args == null) {
            return null;
        }
        String ext = resource.getFileExtension();
        String name = resource.getName();
        String baseName = name.substring(0, name.length() - ext.length());
        String inputName = String.valueOf(baseName) + this.getInputFormat();
        String outputName = String.valueOf(baseName) + this.getOutputFormat();
        if (baseName.indexOf(32) >= 0) {
            inputName = "\"" + inputName + "\"";
            outputName = "\"" + outputName + "\"";
        }
        if (args.indexOf("%input") >= 0) {
            args = args.replaceAll("%input", inputName);
        }
        if (args.indexOf("%output") >= 0) {
            args = args.replaceAll("%output", outputName);
        }
        if (args.indexOf("%fullinput") >= 0) {
            args = args.replaceAll("%fullinput", String.valueOf(resource.getParent().getLocation().toFile().getAbsolutePath()) + File.separator + inputName);
        }
        if (args.indexOf("%fulloutput") >= 0) {
            args = args.replaceAll("%fulloutput", String.valueOf(resource.getParent().getLocation().toFile().getAbsolutePath()) + File.separator + outputName);
        }
        return args;
    }

    protected abstract boolean parseErrors(IResource var1, String var2);

    public boolean isValid() {
        if (this.getProgramPath() == null) {
            return false;
        }
        File f = new File(this.getProgramPath());
        return f.exists() && f.isFile();
    }

    public void run(IResource resource) throws CoreException {
        File sourceDir = resource.getLocation().toFile().getParentFile();
        String programPath = this.getProgramPath();
        File exec = new File(programPath);
        if (!exec.exists()) {
            throw new CoreException(TexlipsePlugin.stat("External program (" + programPath + ") not found"));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(exec.getAbsolutePath());
        PathUtils.tokenizeEscapedString(this.getArguments(resource), list);
        String[] command = list.toArray(new String[0]);
        String console = null;
        if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("builderConsole")) {
            console = this.getProgramName();
        }
        this.extrun.setup(command, sourceDir, console);
        String output = null;
        try {
            try {
                String[] query = this.getQueryString();
                output = query != null ? this.extrun.run(query) : this.extrun.run();
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, TexlipsePlugin.getPluginId(), 4, "Building the project: ", (Throwable)e));
            }
        }
        finally {
            this.extrun.stop();
        }
        if (this.parseErrors(resource, output)) {
            throw new BuilderCoreException(TexlipsePlugin.stat("Errors during build. See the problems dialog."));
        }
    }

    public void stop() {
        if (this.extrun != null) {
            this.extrun.stop();
        }
    }

    protected String[] getQueryString() {
        return null;
    }

    protected static void createMarker(IResource resource, Integer lineNumber, String message, String markerType, int severity) {
        IMarker marker;
        int lineNr = -1;
        if (lineNumber != null) {
            lineNr = lineNumber;
        }
        if ((marker = AbstractProgramRunner.findMarker(resource, lineNr, message, markerType)) == null) {
            try {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("message", message);
                map.put("severity", new Integer(severity));
                if (lineNumber != null) {
                    map.put("lineNumber", lineNumber);
                }
                MarkerUtilities.createMarker((IResource)resource, map, (String)markerType);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void createLayoutMarker(IResource resource, Integer lineNumber, String message) {
        String markerType = TexlipseBuilder.LAYOUT_WARNING_TYPE;
        int severity = 1;
        AbstractProgramRunner.createMarker(resource, lineNumber, message, markerType, severity);
    }

    public static void createMarker(IResource resource, Integer lineNumber, String message, int severity) {
        String markerType = TexlipseBuilder.MARKER_TYPE;
        AbstractProgramRunner.createMarker(resource, lineNumber, message, markerType, severity);
    }

    public static void createMarker(IResource resource, Integer lineNumber, String message) {
        AbstractProgramRunner.createMarker(resource, lineNumber, message, 2);
    }

    public static IMarker findMarker(IResource resource, int lineNr, String message, String type) {
        try {
            IMarker[] tasks;
            IMarker[] iMarkerArray = tasks = resource.findMarkers(type, true, 0);
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Object lNrObj = marker.getAttribute("lineNumber");
                int lNr = -1;
                if (lNrObj != null) {
                    lNr = (Integer)lNrObj;
                }
                if (lNr == lineNr && marker.getAttribute("message").equals(message)) {
                    return marker;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

