/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderCoreException;
import net.sourceforge.texlipse.builder.ProjectFileTracking;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFileManager {
    private final IProject project;
    private final ProjectFileTracking tracking;
    private IContainer sourceDir;
    private IFolder outputDir;
    private IFolder tempDir;
    private String format;
    private IFile sourceFile;
    private IFile currentSourceFile;
    private Set<IPath> movedFiles;

    private static IFile moveFile(IProject project, IFile sourceFile, IContainer destContainer, String destName, IProgressMonitor monitor) throws CoreException {
        if (sourceFile != null && sourceFile.exists() && destName != null) {
            Path destRelPath = new Path(destName);
            IFile dest = destContainer.getFile((IPath)destRelPath);
            if (dest.exists()) {
                File outFile = new File(sourceFile.getLocationURI());
                File destFile = new File(dest.getLocationURI());
                try {
                    int l;
                    FileOutputStream out = new FileOutputStream(destFile);
                    out.getChannel().tryLock();
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(outFile));
                    byte[] buf = new byte[4096];
                    while ((l = in.read(buf)) != -1) {
                        out.write(buf, 0, l);
                    }
                    in.close();
                    out.close();
                    sourceFile.delete(true, monitor);
                }
                catch (IOException iOException) {
                    dest.delete(true, monitor);
                    sourceFile.move(dest.getFullPath(), true, monitor);
                }
            } else {
                sourceFile.move(dest.getFullPath(), true, monitor);
            }
            monitor.worked(1);
            return dest;
        }
        return null;
    }

    private IFile getSelectedOutputFile() {
        String fileName = TexlipseProperties.getOutputFileName(this.project);
        if (fileName != null) {
            if (this.outputDir == null) {
                return this.project.getFile(fileName);
            }
            return this.outputDir.getFile(fileName);
        }
        return null;
    }

    private IContainer getSelectedOutputContainer(boolean markAsDerived, IProgressMonitor monitor) throws CoreException {
        if (this.outputDir != null) {
            if (!this.outputDir.exists()) {
                this.outputDir.create(true, true, monitor);
            }
            if (markAsDerived) {
                this.outputDir.setDerived(true);
            }
            return this.outputDir;
        }
        return this.project;
    }

    private IFile getActualSourceFile() {
        if (this.currentSourceFile == null) {
            return this.sourceFile;
        }
        return this.currentSourceFile;
    }

    private IContainer getActualSourceContainer() {
        if (this.currentSourceFile == null) {
            if (this.sourceFile != null) {
                return this.sourceFile.getParent();
            }
            return null;
        }
        return this.currentSourceFile.getParent();
    }

    private long getOutputFileDate() {
        IFile of = this.getSelectedOutputFile();
        if (of != null && of.exists()) {
            return of.getLocalTimeStamp();
        }
        return -1L;
    }

    private Set<IPath> moveFiles(IContainer source, IContainer dest, Set<IPath> nameSet, boolean markAsDerived, boolean force, IProgressMonitor monitor) throws CoreException {
        HashSet<IPath> newNames = new HashSet<IPath>();
        if (nameSet != null && !nameSet.isEmpty()) {
            IPath sourcePath = source.getProjectRelativePath();
            IPath destPath = dest != null ? dest.getProjectRelativePath() : sourcePath;
            boolean moveFiles = !sourcePath.equals((Object)destPath);
            int sourceSeg = sourcePath.segmentCount();
            IPath[] sortedNames = nameSet.toArray(new IPath[0]);
            Arrays.sort(sortedNames, new Comparator<IPath>(){

                @Override
                public int compare(IPath o1, IPath o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            IPath[] iPathArray = sortedNames;
            int n = sortedNames.length;
            int n2 = 0;
            while (n2 < n) {
                IPath filePath = iPathArray[n2];
                if (sourcePath.isPrefixOf(filePath)) {
                    IFile currentFile = this.project.getFile(filePath);
                    if (moveFiles) {
                        IPath destFilePath = destPath.append(filePath.removeFirstSegments(sourceSeg));
                        IFile destFile = this.project.getFile(destFilePath);
                        if (currentFile.exists() && (force || !destFile.exists())) {
                            IContainer destFolder = destFile.getParent();
                            if (destFolder instanceof IFolder && !destFolder.exists() && force) {
                                ((IFolder)destFolder).create(true, true, monitor);
                                if (markAsDerived) {
                                    destFolder.setDerived(true);
                                }
                            }
                            if (destFolder.exists()) {
                                if (destFile.exists() && force) {
                                    destFile.delete(true, monitor);
                                }
                                currentFile.move(destFile.getFullPath(), true, monitor);
                                if (markAsDerived && destFile.exists()) {
                                    destFile.setDerived(true);
                                }
                                newNames.add(destFilePath);
                            }
                        }
                    } else if (markAsDerived && currentFile.exists()) {
                        currentFile.setDerived(true);
                    }
                    monitor.worked(1);
                }
                ++n2;
            }
        }
        return newNames;
    }

    private void deleteFiles(Set<IPath> nameSet, IProgressMonitor monitor) throws CoreException {
        if (nameSet == null || nameSet.isEmpty()) {
            return;
        }
        HashSet<IContainer> subFolders = new HashSet<IContainer>();
        for (IPath filePath : nameSet) {
            IFile currentFile = this.project.getFile(filePath);
            if (currentFile.exists()) {
                IContainer folder = currentFile.getParent();
                subFolders.add(folder);
                currentFile.delete(true, monitor);
            }
            monitor.worked(1);
        }
        for (IContainer folder : subFolders) {
            if (folder.exists() && folder.members().length == 0) {
                folder.delete(true, monitor);
            }
            monitor.worked(1);
        }
    }

    private Set<IPath> moveOutputFiles(IProgressMonitor monitor) throws CoreException {
        String outputBaseName;
        final boolean markAsDerived = "true".equals(TexlipseProperties.getProjectProperty((IResource)this.project, "markDer"));
        String[] derivedExts = TexlipsePlugin.getPreferenceArray("derivedFiles");
        IFile aSourceFile = this.getActualSourceFile();
        IContainer aSourceContainer = this.getActualSourceContainer();
        IFile sOutputFile = this.getSelectedOutputFile();
        final IContainer sOutputContainer = this.getSelectedOutputContainer(markAsDerived, monitor);
        if (aSourceFile == null || aSourceContainer == null || sOutputFile == null || sOutputContainer == null) {
            return null;
        }
        String dotFormat = String.valueOf('.') + this.format;
        String sourceBaseName = OutputFileManager.stripFileExt(aSourceFile.getName(), null);
        final boolean moveFiles = !sourceBaseName.equals(outputBaseName = OutputFileManager.stripFileExt(sOutputFile.getName(), dotFormat)) || !sOutputContainer.equals((Object)aSourceContainer);
        final Map<IPath, String> outputFiles = ProjectFileTracking.getOutputNames(aSourceContainer, sourceBaseName, derivedExts, this.format, monitor);
        if ((moveFiles || markAsDerived) && !outputFiles.isEmpty()) {
            final HashSet<IPath> movedFiles = new HashSet<IPath>(outputFiles.size());
            this.project.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (Map.Entry entry : outputFiles.entrySet()) {
                        IFile currentFile = OutputFileManager.this.project.getFile((IPath)entry.getKey());
                        if (moveFiles) {
                            String destName = String.valueOf(outputBaseName) + (String)entry.getValue();
                            IFile dest = OutputFileManager.moveFile(OutputFileManager.this.project, currentFile, sOutputContainer, destName, monitor);
                            if (dest != null && markAsDerived) {
                                dest.setDerived(true);
                            }
                            movedFiles.add(dest.getProjectRelativePath());
                            continue;
                        }
                        if (markAsDerived) {
                            currentFile.setDerived(true);
                        }
                        movedFiles.add((IPath)entry.getKey());
                    }
                }
            }, monitor);
            return movedFiles;
        }
        return outputFiles.keySet();
    }

    private void moveTempFiles(final Set<IPath> excludes, IProgressMonitor monitor) throws CoreException {
        final IContainer aSourceContainer = this.getActualSourceContainer();
        if (this.tracking.isInitial() || aSourceContainer == null || !aSourceContainer.exists()) {
            return;
        }
        final boolean markAsDerived = "true".equals(TexlipseProperties.getProjectProperty((IResource)this.project, "markTmpDer"));
        final String[] tempExts = TexlipsePlugin.getPreferenceArray("tempFileExts");
        if (markAsDerived || this.tempDir != null) {
            this.project.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (OutputFileManager.this.movedFiles != null) {
                        if (excludes != null) {
                            OutputFileManager.this.movedFiles.removeAll(excludes);
                        }
                        OutputFileManager.this.moveFiles(OutputFileManager.this.sourceDir, (IContainer)OutputFileManager.this.tempDir, OutputFileManager.this.movedFiles, markAsDerived, true, monitor);
                    }
                    Set<IPath> newTempNames = OutputFileManager.this.tracking.getNewTempNames(aSourceContainer, tempExts, OutputFileManager.this.format, monitor);
                    if (excludes != null) {
                        newTempNames.removeAll(excludes);
                    }
                    OutputFileManager.this.moveFiles(OutputFileManager.this.sourceDir, (IContainer)OutputFileManager.this.tempDir, newTempNames, markAsDerived, true, monitor);
                }
            }, monitor);
        }
    }

    private void restoreTempFiles(IProgressMonitor monitor) throws CoreException {
        Set<IPath> tempNames = this.tracking.getTempFiles();
        if (this.tempDir == null || tempNames.isEmpty()) {
            this.movedFiles = new HashSet<IPath>();
            return;
        }
        this.project.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                OutputFileManager.this.movedFiles = OutputFileManager.this.moveFiles((IContainer)OutputFileManager.this.tempDir, OutputFileManager.this.sourceDir, OutputFileManager.this.tracking.getTempFiles(), false, false, monitor);
            }
        }, monitor);
    }

    private void refreshView(IProgressMonitor monitor) throws CoreException {
        this.sourceDir.refreshLocal(2, monitor);
        if (this.outputDir != null && !this.sourceDir.getProjectRelativePath().isPrefixOf(this.outputDir.getProjectRelativePath())) {
            this.outputDir.refreshLocal(1, monitor);
        }
        if (this.tempDir != null && !this.sourceDir.getProjectRelativePath().isPrefixOf(this.tempDir.getProjectRelativePath())) {
            this.tempDir.refreshLocal(2, monitor);
        }
        if (!this.sourceDir.getLocation().equals((Object)this.project.getLocation())) {
            this.project.refreshLocal(1, monitor);
        }
    }

    public static String stripFileExt(String name, String ext) {
        if (name != null) {
            int extLen;
            if (ext == null) {
                int idx = name.lastIndexOf(46);
                if (idx > 0) {
                    return name.substring(0, idx);
                }
                return name;
            }
            int nameLen = name.length();
            if (nameLen > (extLen = ext.length())) {
                return name.substring(0, nameLen - extLen);
            }
            return "";
        }
        return name;
    }

    public OutputFileManager(IProject project, ProjectFileTracking tracking) {
        this.project = project;
        this.tracking = tracking;
        this.init();
    }

    public void init() {
        this.sourceDir = TexlipseProperties.getProjectSourceDir(this.project);
        this.outputDir = TexlipseProperties.getProjectOutputDir(this.project);
        this.tempDir = TexlipseProperties.getProjectTempDir(this.project);
        this.format = TexlipseProperties.getProjectProperty((IResource)this.project, "outputFormat");
        this.sourceFile = TexlipseProperties.getProjectSourceFile(this.project);
    }

    public void performBeforeBuild(IProgressMonitor monitor) throws CoreException {
        this.tracking.refreshSnapshots(this.sourceDir, monitor);
        this.restoreTempFiles(monitor);
    }

    public void performAfterBuild(IProgressMonitor monitor) throws CoreException {
        CoreException ex;
        block8: {
            block7: {
                ex = null;
                this.refreshView(monitor);
                Set<IPath> outputFiles = null;
                try {
                    outputFiles = this.moveOutputFiles(monitor);
                }
                catch (CoreException coreException) {
                    ex = new BuilderCoreException(TexlipsePlugin.stat(TexlipsePlugin.getResourceString("builderCoreErrorOutputBlock")));
                }
                try {
                    this.moveTempFiles(outputFiles, monitor);
                }
                catch (CoreException coreException) {
                    if (ex != null) break block7;
                    ex = new BuilderCoreException(TexlipsePlugin.stat(TexlipsePlugin.getResourceString("builderCoreErrorTempBlock")));
                }
            }
            try {
                this.refreshView(monitor);
            }
            catch (CoreException e) {
                if (ex != null) break block8;
                ex = e;
            }
        }
        this.tracking.clearSnapshots();
        if (ex != null) {
            throw ex;
        }
    }

    public void cleanOutputFile(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(TexlipsePlugin.getResourceString("builderSubTaskCleanOutput"));
        IFile outputFile = this.getSelectedOutputFile();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete(true, monitor);
        }
        monitor.worked(1);
    }

    public void cleanTempFiles(IProgressMonitor monitor) throws CoreException {
        if (this.tempDir != null && this.tempDir.exists()) {
            monitor.beginTask(TexlipsePlugin.getResourceString("builderSubTaskClean"), this.tempDir.members().length);
            monitor.subTask(TexlipsePlugin.getResourceString("builderSubTaskCleanTemp"));
            Set<IPath> currentTmpFiles = this.tracking.getTempFolderNames(monitor);
            this.deleteFiles(currentTmpFiles, monitor);
        }
        this.tracking.clearSnapshots();
    }

    public boolean isUpToDate() {
        long lastBuildStamp = this.getOutputFileDate();
        IResource[] files = TexlipseProperties.getAllProjectFiles(this.project);
        int i = 0;
        while (i < files.length) {
            long stamp = files[i].getLocalTimeStamp();
            if (stamp > lastBuildStamp) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IFile getCurrentSourceFile() {
        return this.currentSourceFile;
    }

    public void setCurrentSourceFile(IFile sourceFile) {
        this.currentSourceFile = sourceFile;
    }
}

