/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexAnnotationHover
implements IAnnotationHover {
    private String getMessage(List<String> markers) {
        if (markers.size() == 1) {
            return markers.get(0);
        }
        StringBuilder out = new StringBuilder("There are several problems at this line:");
        for (String element : markers) {
            out.append(System.getProperty("line.separator"));
            out.append(" -");
            out.append(element);
        }
        return out.toString();
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        IDocument document = sourceViewer.getDocument();
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        LinkedList<String> lineMarkers = null;
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            MarkerAnnotation a;
            Annotation o = (Annotation)e.next();
            if (!(o instanceof MarkerAnnotation) || !this.isRulerLine(model.getPosition((Annotation)(a = (MarkerAnnotation)o)), document, lineNumber)) continue;
            if (lineMarkers == null) {
                lineMarkers = new LinkedList<String>();
            }
            lineMarkers.add(a.getMarker().getAttribute("message", null));
        }
        if (lineMarkers != null) {
            return this.getMessage(lineMarkers);
        }
        return null;
    }

    private boolean isRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return line == document.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }
}

