/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.texlipse.model.DocumentReference;
import net.sourceforge.texlipse.model.PartialRetriever;
import net.sourceforge.texlipse.model.ReferenceEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceContainer {
    private Map<String, List<ReferenceEntry>> referenceHash = new HashMap<String, List<ReferenceEntry>>(4);
    private List<ReferenceEntry> sortedReferences = null;
    private int size = 0;

    public void addRefSource(String key, List<ReferenceEntry> refs) {
        if (key != null && key.endsWith(".aux")) {
            Iterator<ReferenceEntry> it = refs.iterator();
            while (it.hasNext()) {
                String x = it.next().key;
                if (!this.binTest(x)) continue;
                it.remove();
            }
        }
        for (ReferenceEntry r : refs) {
            r.fileName = key;
        }
        this.size += refs.size();
        List<ReferenceEntry> al = this.referenceHash.put(key, refs);
        if (al != null) {
            this.size -= al.size();
        }
    }

    public boolean updateRefSource(String key, List<ReferenceEntry> refs) {
        if (this.referenceHash.containsKey(key)) {
            this.addRefSource(key, refs);
            this.organize();
            return true;
        }
        return false;
    }

    public void organize() {
        if (this.referenceHash.size() == 0) {
            this.sortedReferences = new ArrayList<ReferenceEntry>(0);
            return;
        }
        List<ReferenceEntry> allRefs = new ArrayList<ReferenceEntry>(this.size);
        if (this.referenceHash.size() > 1) {
            for (List<ReferenceEntry> refList : this.referenceHash.values()) {
                allRefs.addAll(refList);
            }
        } else if (this.referenceHash.size() == 1) {
            Iterator<List<ReferenceEntry>> iter = this.referenceHash.values().iterator();
            allRefs = iter.next();
        }
        this.sortedReferences = allRefs;
        Collections.sort(this.sortedReferences, new Comparator<ReferenceEntry>(){

            @Override
            public int compare(ReferenceEntry o1, ReferenceEntry o2) {
                return o1.getkey(true).compareTo(o2.getkey(true).toLowerCase());
            }
        });
    }

    public List<String> updateBibHash(String[] newBibs) {
        LinkedList<String> toParse = new LinkedList<String>();
        HashMap<String, List<ReferenceEntry>> newHash = new HashMap<String, List<ReferenceEntry>>(newBibs.length);
        int newSize = 0;
        String[] stringArray = newBibs;
        int n = newBibs.length;
        int n2 = 0;
        while (n2 < n) {
            String bib = stringArray[n2];
            List<ReferenceEntry> al = this.referenceHash.get(bib);
            if (al != null) {
                newHash.put(bib, al);
                newSize += al.size();
            } else {
                toParse.add(bib);
            }
            ++n2;
        }
        this.referenceHash = newHash;
        this.size = newSize;
        return toParse;
    }

    public boolean checkFreshness(String[] newBibs) {
        if (newBibs.length != this.referenceHash.size()) {
            return false;
        }
        String[] stringArray = newBibs;
        int n = newBibs.length;
        int n2 = 0;
        while (n2 < n) {
            String bib = stringArray[n2];
            if (!this.referenceHash.containsKey(bib)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean binTest(String key) {
        if (this.sortedReferences == null || this.sortedReferences.size() == 0) {
            return false;
        }
        int nr = PartialRetriever.getEntry(key, this.sortedReferences, true);
        return nr >= 0;
    }

    public void removeFalseEntries(List<DocumentReference> errors) {
        Iterator<DocumentReference> iter = errors.iterator();
        while (iter.hasNext()) {
            DocumentReference docRef = iter.next();
            if (!this.binTest(docRef.getKey())) continue;
            iter.remove();
        }
    }

    public List<ReferenceEntry> getSortedReferences() {
        return this.sortedReferences;
    }
}

