/****************************************************************************
 *
 * Copyright (c) 1992-1996, 1999  John Forkosh Associates, Inc.
 * This program can be redistributed and/or modified under the terms
 * of the LaTeX Project Public License Distributed from CTAN
 * archives in directory macros/latex/base/lppl.txt; either
 * version 1 of the License, or any later version.
 * --------------------------------------------------------------------------
 *
 * Program:	tp wpfilespec [-f inputfile] [options]
 *
 * Purpose:	Converts a WordPerfect document file
 *		to a TeX file.
 *
 * Arguments:	wpfilespec	filename specification (optionally preceded
 *				by path) of WordPerfect document file to be
 *				converted.
 *		-f inputfile	input filename containing variable=value
 *				options
 *		options		of the form variable=value (these will
 *				override or supplement anything read
 *				from inputfile).
 *
 * Notes:     o
 *
 * Source:	TEXPERF.C
 *
 * --------------------------------------------------------------------------
 * Revision History:
 * 12/24/92	J.Forkosh	Installation
 * 08/08/96	J.Forkosh	Modified and streamlined for gpl release
 * 03/03/99	J.Forkosh	Copuright modified as requested by S.Rahtz
 *
 ***************************************************************************/
/* --- standard headers --- */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* --- application headers --- */
#include "texperf.h"

/* --------------------------------------------------------------------------
Input information
-------------------------------------------------------------------------- */
static	char	pgmname[64] = "\000";	/* program name in argv[0] */
static	char	varfile[64] = "\000";	/* user input file after -f switch */
static	char	wpfile[64] = "\000";	/* input WordPerfect document file */
static	char	texfile[64] = "\000";	/* output TeX file */
static	char	hdrfile[64] = "\000";	/* input ascii user header file */
static	char	mmddyy[64] = "\000";	/* date (default=today's) */
static	char	*userargs[64];		/* arbitrary user arguments */
static	char	*mathvars[64];		/* tokens to be treated as mathmode */
static	int	textype = TEXTYPE;	/* TeX, LaTeX, or AMS-TeX */
static	char	title[128] = "Document Title"; /* document title */
static	char	author[128] = "Document Author"; /* document author */
static	long	maxchars = (-1L);	/* max chars to process (debugging) */
static	int	msglevel = 1;		/* debugging message level */
/* --- user-modifiable attribute strings --- */
static	char	bold[64] = "\000";	/* bold attribute command string */
static	struct	{ int type; char *string; } /* attribute and xlation */
	attributes[] =
		  { { BOLD, bold },	/* set bold attribute */
		    { -1, NULL }
		  } ; /* --- end-of-attributes --- */
#if 0
/* --- input variable structure --- */
static	VARDEF	tpvars[] =		/* input variables */
  {
    /* --- user-modifiable parameters must be placed in this order --- */
    { "CHARSET",	NULL,		STRFIELD,	SCALARVAR },
    /* --- variables set by putcmdline (if present) --- */
    { "PGMNAME",	pgmname,	STRFIELD,	SCALARVAR }, /*argv0*/
    { "VARFILE",	varfile,	STRFIELD,	SCALARVAR }, /*-farg*/
    /* --- user input --- */
    { "WPFILE",		wpfile,		STRFIELD,	SCALARVAR },
    { "TEXFILE",	texfile,	STRFIELD,	SCALARVAR },
    { "HDRFILE",	hdrfile,	STRFIELD,	SCALARVAR },
    { "ARGS",		userargs,	STRFIELD,	VECTORVAR },
    { "MATHVARS",	mathvars,	STRFIELD,	VECTORVAR },
    { "TEXTYPE",	&textype,	INTFIELD,	SCALARVAR },
    { "TITLE",		title,		STRFIELD,	SCALARVAR },
    { "AUTHOR",		author,		STRFIELD,	SCALARVAR },
    { "MMDDYY",		mmddyy,		STRFIELD,	SCALARVAR },
    { "MAXCHARS",	&maxchars,	LONGFIELD,	SCALARVAR },
    { "MSGLEVEL",	&msglevel,	INTFIELD,	SCALARVAR },
    /* --- attribute command strings --- */
    { "BOLD",		bold,		STRFIELD,	SCALARVAR },
    { (char *)NULL, (void *)NULL, -1 }	/* terminator */
  } ; /* --- end-of-structure tpvars[] --- */
#endif
  
/* --- entry point --- */
main ( argc, argv )
int	argc;
char	*argv[];
{
/* --------------------------------------------------------------------------
Declarations and Allocations
-------------------------------------------------------------------------- */
TPFCB	*tpfcb=(TPFCB *)NULL, *tpopen(); /* TexPerfect file control block */
char	***setwpchartbl();		/* returns address of wpchrtbl */
void	*wpchartbl = (void *)NULL;	/* addr returned by setwpchartbl() */
int	itype;				/* attribute index */

/* --------------------------------------------------------------------------
Set addresses of user-modifiable table parameters
-------------------------------------------------------------------------- */
wpchartbl = (void *)(setwpchartbl());	/* user can modify wpchartbl */
/*tpvars[0].address= (void *)(setwpchartbl());*/ /*user can modify wpchartbl*/

/* --------------------------------------------------------------------------
Pick up command-line arguments
-------------------------------------------------------------------------- */
if ( argc > 1 )				/* user supplied some args */
  { if ( !ismychar(argv[1],'=') )	/* no = in arg, so must be wpfile */
      strcpy(wpfile,argv[1]);		/* replace default file spec */
    /*putcmdline(tpvars,argc,argv);*/ }	/* interpret variable=value args */

/* --------------------------------------------------------------------------
Display usage and help (incomplete help removed for copyleft streamlining)
-------------------------------------------------------------------------- */
if ( argc <= 1 )			/* no args, so display usage */
  { printf("Usage: tp wpfile [options]\n");
    goto end_of_job; }			/* quit after usage display */
if ( ismychar("H?",toupper(*wpfile))	/* if h or ? is 1st char of 1st arg */
&&   wpfile[1] == '\000' )		/* and only char, then help request */
  { printf("Sorry, no help available.\n"); /* display,navigate help screens */
    goto end_of_job; }			/* quit after help display */

/* --------------------------------------------------------------------------
Set Default Tex Output Filename
-------------------------------------------------------------------------- */
/* --- if no name supplied use WP filename plus .wpx extension --- */
if ( *texfile == '\000' )
  {
  char	*texptr = texfile;		/* texfile ptr, and strchr() return */
  strcpy(texfile,wpfile);		/* initialize output file as input */
  while ( *texptr != (char)NULL )	/* for each char in texfile string */
    { *texptr = (char)(tolower(*texptr)); /* convert to lowercase */
      texptr++; }			/* get next char */
  texptr = strchr(texfile,'.');		/* find delimiter dot in filename */
  if ( texptr == (char *)NULL )		/* no filename extension */
    strcat(texfile,".wpx");		/*so explicitly set .wpx for WP TeX*/
  else /* --- make sure input isn't already using .wpx as extension --- */
    if ( memcmp(texptr,".wpx",4) == 0 ) /*input using .wpx extension*/
      strcpy(texptr,".out");		/* so we'll use .out instead */
    else strcpy(texptr,".wpx");		/* else we'll use .wpx ourselves */
  } /* --- end-of-if(*texfile==0) --- */

/* --------------------------------------------------------------------------
Allocate and Initialize File Control Block, Open the Files, and Set Options.
-------------------------------------------------------------------------- */
/* --- allocate and initialize control block, and open files --- */
tpfcb = tpopen(wpfile,texfile,msglevel); /* open WP, TeX files */
if ( tpfcb == (TPFCB *)NULL )		/* failed to open files */
  goto end_of_job;			/* can't do anything, so quit */
/* --- set user options --- */
/* tpfcb->tpvars = tpvars; */		/* address of input vardef struct */
tpfcb->textype = textype;		/* TeX, LaTeX, or AMS-TeX */
tpfcb->msglevel = msglevel;		/* user-requested message level */
if ( *mmddyy == '\000' )		/* no user-supplied date */
  strcpy(mmddyy,"mm/dd/yy"/*today()*/);	/* so default to today's date */
strcpy(wpfile,tpfcb->wpdoc.filename);	/* WP input filename + extension */
/* *wpfile = toupper(*wpfile); */	/* capitalize first character */
strcpy(texfile,tpfcb->tpfile.filename);	/* tex output filename + extension */
/* --- set user attribute strings --- */
for ( itype=0; attributes[itype].type > 0; itype++ ) /* for each attribute */
  {
  tpfcb->argstr = attributes[itype].string; /* pick up user input string */
  if ( *(tpfcb->argstr) != '\000' )	/* user wants attribute modified */
    texcommand(tpfcb,attributes[itype].type,SETCMD); /* so modify it */
  } /* --- end-of-for(itype) --- */

/* --------------------------------------------------------------------------
Initialization
-------------------------------------------------------------------------- */
/* --- display header information --- */
if ( msglevel >= 3 )			/* header display requested */
  printf("tp> WPfile: %s, document offset: %ld\n", /*display input filename*/
  tpfcb->wpdoc.filename,tpfcb->wpdocoffset); /* and document offset */
if ( msglevel >= 3 )			/* header display requested */
  /*showvardef(tpvars,NULL)*/;		/* display input variables */
/* --- copy WordPerfect prefix --- */
wppfxcpy(tpfcb);			/* copy prefix */
/* --- place file ptr at beginning of document area --- */
if ( fseek(tpfcb->wpdoc.fp,tpfcb->wpdocoffset,SEEK_SET) /* start of doc */
!=   0 ) goto end_of_job;		/* quit if seek() fails */

/* --------------------------------------------------------------------------
Process
-------------------------------------------------------------------------- */
/* --- process document one token at a time --- */
while ( 1 )				/* until EOF */
  {
  if ( maxchars > 0L			/* see if we have a limit */
  &&   tpfcb->wpdocsize > maxchars )	/* and if we've passed it */
    break;				/* then stop processing */
  if ( wp2tex(tpfcb,NULL,NULL)		/* process the next token */
  ==   EOF ) break;			/* until end-of-job signalled */
  } /* --- end-of-while(1) --- */
tpfcb->texmode = setmode(tpfcb,PARMODE); /* back to paragraph mode */

/* --------------------------------------------------------------------------
End-of-Job
-------------------------------------------------------------------------- */
end_of_job:
  if ( tpfcb != (TPFCB *)NULL )		/* if initialization succeeded */
    {
    if ( tpfcb->isheader < 99 )		/* see if user wants header/trailer */
      texhdr(tpfcb,TRAILER);		/* write trailer at end-of-file */
    tpclose(tpfcb);			/* close files and free buffers */
    if ( msglevel >= 3 )		/* display requested */
      printf("tp> successful end-of-job\n");
    } /* --- end-of-if(tpfcb!=NULL) --- */
} /* --- end-of-main texperf() --- */
/* ------------------------ END-OF-FILE TEXPERF.C ------------------------ */
