#ifndef	_WPCHRSET
#define	_WPCHRSET
/****************************************************************************
 *
 * Copyright (c) 1992, John Forkosh Associates.  All rights reserved.
 * --------------------------------------------------------------------------
 *
 * Header:	wpchrset
 *
 * Purpose:	Defines the WordPerfect character sets
 *		and character type codes.
 *
 * Source:	WPCHRSET.H
 *
 * Notes:     o
 *
 * --------------------------------------------------------------------------
 * Revision History:
 * 12/24/92	J.Forkosh	Installation.
 *
 ***************************************************************************/

/* --------------------------------------------------------------------------
Code type by character
-------------------------------------------------------------------------- */
static	int wpcodetblsz = 224;		/* #entries in wpcodetbl[] */
static	int wpcodetbl[] =		/* char indexes its code type */
  {
  /* Control characters = 01x - 1Fx: */
  /* ---00--  --01--  --02--  --03--  --04--  --05--  --06--  --07--- */
      ERROR,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   /*00*/
       CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   /*01*/
       CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   /*02*/
       CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   CTRL,   /*03*/
  /* Ascii and WhiteSpace characters = 20x - 7Ex: */
  /* ---00--  --01--  --02--  --03--  --04--  --05--  --06--  --07--- */
      WHITE,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*04*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*05*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*06*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*07*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*08*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*09*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*10*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*11*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*12*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*13*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,   /*14*/
      ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ASCII,  ERROR,   /*15*/
  /* Single-byte functions = 80x - BFx: */
  /* ---00--  --01--  --02--  --03--  --04--  --05--  --06--  --07--- */
       FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   /*16*/
       FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   /*17*/
       FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   /*18*/
       FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   /*19*/
       FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   /*20*/
       FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   /*21*/
       FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   /*22*/
       FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   FUNC,   /*23*/
  /* Fixed-length functions = C0x - CFx: */
  /* ---00--  --01--  --02--  --03--  --04--  --05--  --06--  --07--- */
     FIXLEN, FIXLEN, FIXLEN, FIXLEN, FIXLEN, FIXLEN, FIXLEN, FIXLEN,   /*24*/
     FIXLEN, FIXLEN, FIXLEN, FIXLEN, FIXLEN, FIXLEN, FIXLEN, FIXLEN,   /*25*/
  /* Variable-length functions = D0x - DFx: */
  /* ---00--  --01--  --02--  --03--  --04--  --05--  --06--  --07--- */
     VARLEN, VARLEN, VARLEN, VARLEN, VARLEN, VARLEN, VARLEN, VARLEN,   /*26*/
     VARLEN, VARLEN, VARLEN, VARLEN, VARLEN, VARLEN, VARLEN, VARLEN,   /*27*/
      ERROR /* --- end-of-table indicator --- */ 
  } ; /* --- end-of-wpcodetbl[] --- */

/* --------------------------------------------------------------------------
Extended character sets initialization
-------------------------------------------------------------------------- */
/* --- string of nulls --- */
#define	 null4	  NULL,   NULL,   NULL,   NULL /* four nulls */
/* --- end-of-set delimiter string --- */
#define	ENDOFSET "end-of-set"

/* --- character set 3 --- */
static	char *wpset3tbl[] =		/* xlation strings for char set 3 */
  { 
  /* -------00------  ------01------  ------02------  ------03------- */
                " ",            " ",            " ",             " ",  /*00*/
                " ",            " ",            " ",             " ",  /*01*/
                "-",            "|",           NULL,            NULL,  /*02*/
    ENDOFSET } ; /* --- end-of-wpset3tbl[] --- */

/* --- character set 4 --- */
static	char *wpset4tbl[] =		/* xlation strings for char set 4 */
  { 
  /* -------00------  ------01------  ------02------  ------03------- */
         "\\bullet",       "\\circ",        "\\Box",      "\\bullet",  /*00*/
               NULL,           NULL,           NULL,            NULL,  /*01*/
               NULL,         "\\ll",         "\\gg",            NULL,  /*02*/
               NULL,           NULL,           NULL,            NULL,  /*03*/
               NULL,  "{1\\over 2}",  "{1\\over 4}",            NULL,  /*04*/
      "{\\small 2}",           NULL,           NULL,            NULL,  /*05*/
               NULL,           NULL,           NULL,            NULL,  /*06*/
               NULL,           NULL,           NULL,            NULL,  /*07*/
               NULL,           NULL,           NULL,            NULL,  /*08*/
               NULL,           NULL,           NULL,      "\\dagger",  /*09*/
        "\\ddagger",           NULL,           NULL,            NULL,  /*10*/
               NULL,           NULL,           NULL,            NULL,  /*11*/
               NULL,           NULL,           NULL,            NULL,  /*12*/
               NULL,           NULL,           NULL,            NULL,  /*13*/
          "\\ldots",           NULL,           NULL,            NULL,  /*14*/
    ENDOFSET } ; /* --- end-of-wpset4tbl[] --- */

/* --- character set 5 --- */
static	char *wpset5tbl[] =		/* xlation strings for char set 5 */
  { 
  /* -------00------  ------01------  ------02------  ------03------- */
       "\\clubsuit","\\diamondsuit",  "\\heartsuit",   "\\spadesuit",  /*00*/
              null4,          null4,                                /*01,02*/
               NULL,        "!\\!!",       "\\surd", "\\updownarrow",  /*03*/
              null4,                                                   /*04*/
  "\\hookleftarrow",           NULL,           NULL,            NULL,  /*05*/
            "\\Box",           NULL,           NULL,       "\\sharp",  /*06*/
           "\\flat",    "\\natural",           NULL,            NULL,  /*07*/
    ENDOFSET } ; /* --- end-of-wpset5tbl[] --- */

/* --- character set 6 --- */
static	char *wpset6tbl[] =		/* xlation strings for char set 6 */
  { 
  /* -------00------  ------01------  ------02------  ------03------- */
                "-",         "\\pm",        "\\leq",         "\\geq",  /*00*/
         "\\propto",            "/",            "/",    "\\setminus",  /*01*/
            "\\div",        "\\mid",     "\\langle",      "\\rangle",  /*02*/
            "\\sim",     "\\approx",      "\\equiv",          "\\in",  /*03*/
            "\\cap",          "\\|",        "\\sum",       "\\infty",  /*04*/
            "\\neg", "\\rightarrow",  "\\leftarrow",     "\\uparrow",  /*05*/
   "\\downarrow","\\leftrightarrow","\\updownarrow","\\triangleright", /*06*/
   "\\triangleleft",   "\\triangle","\\bigtriangledown",    "\\cdot",  /*07*/
           "\\cdot",       "\\circ",     "\\bullet",            NULL,  /*08*/
               NULL,         "\\mu",            "-",       "\\times",  /*09*/
            "\\int",       "\\prod",         "\\mp",       "\\nabla",  /*10*/
        "\\partial",           "\'",           "\"",    "\\vec{\\ }",  /*11*/
               NULL,        "\\ell",       "\\hbar",          "\\Im",  /*12*/
           "\\Re","\\wp","\\rightleftharpoons","\\rightleftharpoons",  /*13*/
     "\\Rightarrow",  "\\Leftarrow",    "\\Uparrow",   "\\Downarrow",  /*14*/
 "\\Leftrightarrow","\\Updownarrow",    "\\nearrow",     "\\searrow",  /*15*/
        "\\nwarrow",    "\\swarrow",        "\\cup",      "\\subset",  /*16*/
         "\\supset",   "\\subseteq",   "\\supseteq",          "\\ni",  /*17*/
       "\\emptyset",      "\\lceil",      "\\rceil",      "\\lfloor",  /*18*/
         "\\rfloor",         "\\ll",         "\\gg",       "\\angle",  /*19*/
         "\\otimes",      "\\oplus",     "\\ominus",            NULL,  /*20*/
           "\\odot",        "\\vee",      "\\wedge",            NULL,  /*21*/
            "\\top",        "\\bot",      "\\frown",       "\\vdash",  /*22*/
          "\\dashv",        "\\Box",        "\\Box",     "\\Diamond",  /*23*/
  "\\Diamond","\\lbrack\\!\\lbrack","\\rbrack\\!\\rbrack",   "\\neq",  /*24*/
     "\\not\\equiv",           NULL,           NULL,            NULL,  /*25*/
           "\\oint",           NULL,           NULL,            NULL,  /*26*/
               NULL,    "\\bigcirc",           NULL,     "\\Diamond",  /*27*/
           "\\star",         "\"\'",      "\\amalg",       "\\simeq",  /*28*/
           "\\cong",       "\\prec",     "\\preceq",        "\\succ",  /*29*/
         "\\succeq",     "\\exists",     "\\forall",            NULL,  /*30*/
               NULL,      "\\uplus",           NULL,            NULL,  /*31*/
          "\\sqcap",      "\\sqcup",   "\\sqsubset",  "\\sqsubseteq",  /*32*/
               NULL,   "\\sqsupset", "\\sqsupseteq",            NULL,  /*33*/
  "\\bigtriangleup","\\bigtriangledown","\\triangleleft","\\triangleright",
         "\\bowtie",      "\\smile",      "\\frown",     "\\bigcirc",  /*35*/
          NULL,"\\hookleftarrow","\\hookrightarrow",      "\\mapsto",  /*36*/
"\\leftharpoonup","\\leftharpoondown","\\rightharpoonup","\\rightharpoondown",
  "\\rightleftharpoons","\\rightleftharpoons", NULL,            NULL,  /*38*/
               NULL,           NULL,           NULL,            NULL,  /*39*/
               NULL,           NULL,           NULL,            NULL,  /*40*/
               NULL,           NULL,           NULL,            NULL,  /*41*/
               NULL,           NULL,           NULL,            NULL,  /*42*/
               NULL,           NULL,           NULL,            NULL,  /*43*/
               NULL,           NULL,           NULL,            NULL,  /*44*/
               NULL,           NULL,           NULL,            NULL,  /*45*/
               NULL,           NULL,           NULL,            NULL,  /*46*/
               NULL,           NULL,           NULL,            NULL,  /*47*/
               NULL,           NULL,           NULL,            NULL,  /*48*/
               NULL,           NULL,           NULL,            NULL,  /*49*/
               NULL,           NULL,           NULL,            NULL,  /*50*/
               NULL,           NULL,           NULL,            NULL,  /*51*/
    "\\not\\exists",      "\\notin",           NULL,            NULL,  /*52*/
    ENDOFSET } ; /* --- end-of-wpset6tbl[] --- */

/* --- character set 7 --- */
static	char *wpset7tbl[] =		/* xlation strings for char set 7 */
  {
  /* -------00------  ------01------  ------02------  ------03------- */
                " ",           NULL,           NULL,            NULL,  /*00*/
           "\\surd",           NULL,           NULL,            NULL,  /*01*/
    ENDOFSET } ; /* --- end-of-wpset7tbl[] --- */

/* --- character set 8 (Greek) --- */
static	char *wpset8tbl[] =		/* xlation strings for char set 8 */
  {
  /* -------00------  ------01------  ------02------  ------03------- */
                "A",      "\\alpha",            "B",        "\\beta",  /*00*/
                "B",       "\\beta",      "\\Gamma",       "\\gamma",  /*01*/
          "\\Delta",      "\\delta",            "E",     "\\epsilon",  /*02*/
                "Z",       "\\zeta",            "H",         "\\eta",  /*03*/
          "\\Theta",      "\\theta",            "I",        "\\iota",  /*04*/
                "K",      "\\kappa",     "\\Lambda",      "\\lambda",  /*05*/
                "M",         "\\mu",            "N",          "\\nu",  /*06*/
             "\\Xi",         "\\xi",            "O",             "o",  /*07*/
             "\\Pi",         "\\pi",            "P",         "\\rho",  /*08*/
          "\\Sigma",      "\\sigma",      "\\Sigma",    "\\varsigma",  /*09*/
                "T",        "\\tau",    "\\Upsilon",     "\\upsilon",  /*10*/
            "\\Phi",        "\\phi",            "X",         "\\chi",  /*11*/
            "\\Psi",        "\\psi",      "\\Omega",       "\\omega",  /*12*/
 "\\acute{\\alpha}","\\acute{\\epsilon}","\\acute{\\eta}","\\acute{\\iota}",
 "\\ddot{\\iota}","\\acute{o}","\\acute{\\upsilon}","\\ddot{\\upsilon}",/*14*/
 "\\acute{\\omega}", "\\varepsilon",   "\\vartheta",         "\\chi",  /*15*/
          "\\varpi",      "\varrho",    "\\Upsilon",      "\\varphi",  /*16*/
          "\\omega",           NULL,           NULL,            NULL,  /*17*/
    ENDOFSET } ; /* --- end-of-wpset8tbl[] --- */

/* --- character set 9 --- */
static	char *wpset9tbl[] =		/* xlation strings for char set 9 */
  {
  /* -------00------  ------01------  ------02------  ------03------- */
          "\\aleph",           NULL,           NULL,            NULL,  /*00*/
    ENDOFSET } ; /* --- end-of-wpset9tbl[] --- */


/* --------------------------------------------------------------------------
Tables of extended character sets
-------------------------------------------------------------------------- */
/* --- table of initialization tables --- */
static	char **wpsettbl[] =		/* one table for each char set */
  {
        NULL,       NULL,       NULL,  wpset3tbl, /* char sets  0 -  3 */
   wpset4tbl,  wpset5tbl,  wpset6tbl,  wpset7tbl, /* char sets  4 -  7 */
   wpset8tbl,  wpset9tbl,       NULL,       NULL, /* char sets  8 - 11 */
        NULL
  } ; /* --- end-of-wpsettbl[] --- */
/* --- fully-allocated tables so users can supply replacement strings --- */
#define	CHARSZ	33			/* maximum chars per string + null */
#define	WPTBLSZ	256			/* maximum char strings per set */
static	char	*wpchar0tbl[WPTBLSZ],	*wpchar1tbl[WPTBLSZ],
		*wpchar2tbl[WPTBLSZ],	*wpchar3tbl[WPTBLSZ],
		*wpchar4tbl[WPTBLSZ],	*wpchar5tbl[WPTBLSZ],
		*wpchar6tbl[WPTBLSZ],	*wpchar7tbl[WPTBLSZ],
		*wpchar8tbl[WPTBLSZ],	*wpchar9tbl[WPTBLSZ],
		*wpchar10tbl[WPTBLSZ],	*wpchar11tbl[WPTBLSZ],
		*wpchar12tbl[WPTBLSZ];
static	char **wpchartbl[] =		/* one table for each char set */
  {
  wpchar0tbl, wpchar1tbl, wpchar2tbl, wpchar3tbl, /* char sets  0 -  3 */
  wpchar4tbl, wpchar5tbl, wpchar6tbl, wpchar7tbl, /* char sets  4 -  7 */
  wpchar8tbl, wpchar9tbl,wpchar10tbl,wpchar11tbl, /* char sets  8 - 11 */
 wpchar12tbl
  } ; /* --- end-of-wpchartbl[] --- */
/* ----------------------- END-OF-FILE WPCHRSET.H ------------------------ */
#endif
