"""
1999 Manuel Gutierrez Algaba
You are free to use , modify, distribute and copy this piece of
python code, if you keep this free copyright notice in it.

sectioner.py Version 1.0

relative sectioning of code: 
Given a source in LaTeX, it generates the \sections, \subsections,
..., in an automatic way.
It abstracts the idea of absolute sectioning of LaTeX , and supplies
relative positioning. It makes document more independent of their
type. The decission article-report-miarticle can be done in the end
, not when you start to write the document.
Possibly you can use it ( adapting it a bit ) in TeX, or another
sorts of languages of typesseting.

how to use:
python  sectioner.py method inputfile outputfile
"""

"""
You use a command in a single line, and in the next line you
put the title of that (sub)section or whatever. And it should
be in the first column of the line.

For example:

\n
Coding Decissions.
<Body of this part>
...

It uses the following commands:

\n : This says the next section is at the same current level.
\+ : This goes a level down
\- : A level up
\+4 ( or any other number ) : 4 levels down
\-4: 4 levels up
\minput{name of file} : This includes another file of sectioner-LaTeX
style.

For more details see the example:
highnest.tex ( a source of sectioner-LaTeX )

"""

import sys
import re
import string

print sys.argv
if not sys.argv[1:] or not sys.argv[2:]  or not sys.argv[3:]:
    print "usage: python  sectioner.py method inputfile outputfile"
    print "method can be 'manolo' or it can be article or report"
    print "And you should include all the parameters"
    sys.exit(2)

method = sys.argv[1]
inputfile = sys.argv[2] 
outputfile = sys.argv[3] 

i = open(inputfile,"r")
lines_of_the_main_file =i.readlines()
i.close()

outputfile = open(outputfile,"w")


# This counters what section we are in
counters = [ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
dic_sections_manolo = { 0:'\\part', 1:'\\section', 2:'\\subsection',
		  3:'\\subsubsection', 4:'\\sssection', 5:'\\ssssection',
		  6:'\\Section', 7:'\\Ssection', 8:'\\Sssection',
		  9:'\\Ssssection', 10: '\\Sssssection',
		  11:'\\SSection', 12:'\\SSsection', 13:'\\SSssection',
		  14:'\\SSsssection'}

dic_sections_article = { 0:'\\section', 1:'\\subsection',
		  2:'\\subsubsection', 3:'\\paragraph', 4:'\\subparagraph'}

dic_sections_report = { 0:'\\chapter', 1:'\\section', 2:'\\subsection',
		  3:'\\subsubsection', 4:'\\paragraph', 5:'\\subparagraph'}

if method=='manolo':
    dic_sections = dic_sections_manolo
elif method =='article':
    dic_sections = dic_sections_article
elif method =='report':
    dic_sections = dic_sections_report
		  
level = 0
next = 0

#print y[240]=="\\n\n"
#print y[274]=="\\+\n"

def process_file(file):
    i = open(file,"r")
    v =i.readlines()
    i.close()
    process_lines_in_file(v)
    del v

minputfile= re.compile("/minput\{(?P<file>[^\}]+)\}.*")

def process_lines_in_file(lines_in_file):
    next = 0
    global level
    for i in lines_in_file:
	if i[0]=="\\"  and i[1] in "+-" and i[2] in "123456789":
	    signo = i[1]
	    if signo == '+':
		level = level + eval(i[2])
	    else:
		level = level - eval(i[2])
	    counters[level] = counters[level] + 1
	    next = 0
	    continue
	if i[0]=="\\" and i[1]=="n":
	    counters[level] = counters[level] + 1
	    next = 1
	    continue
	if i[0]=="\\" and i[1]=="+":
	    level = level + 1
	    counters[level] = 1
	    next = 1
	    continue
	if i[0]=="\\" and i[1]=="-":
	#counters[level] = 0
	    level = level - 1
	    counters[level] = counters[level] + 1
	    next = 1
	    continue
	mmatch = minputfile.match(i)
	if not mmatch is None:
	    print mmatch.group('file')
	    process_file(mmatch.group('file'))	    
	    continue
	if next == 1:
	#print counters[level]
	#print range(0,1)
	    t= ""
	    for k in range(0,level+1):
		t = t+ `counters[k]`+"."
		#print t,i, # por culpa de tener antes una linea
	    outputfile.write(dic_sections[level]+"{"+string.strip(i)+"}\n")
	    next = 0
	    continue
	outputfile.write(i)

process_lines_in_file(lines_of_the_main_file)

outputfile.close()
