#! /bin/sh
# Script to grind nice program listings using TeX.
#
# written Feb, 1985 by Van Jacobson, Lawrence Berkeley Laboratory (adapted
# from the 4.2bsd "vgrind" script).
#
# Translated to Bourne Shell, March 1987, Lou Salkind, New York University
#
# Since TeX output handling is site dependent, you'll have to edit this
# file to get output to your local typesetting device(s).  Our site uses
# the flags "-v" (versatec output), "-q" (qms output) and "-o" (keep dvi file)
# to route output.  Put something appropriate to your site at the "PUT OUTPUT
# HANDLING..." comment at the end of this script.  If you've already dealt
# with this in your local tex command, just change the -v/q/k (or whatever)
# cases in the first "switch" to set variable "texoptions" appropriately.
#
b=/usr/local/lib/tfontedpr
tex=/usr/local/bin/tex
options=
texoptions=
files=
head=""
format=""
output="dvi"
outputfile=tgrind.dvi
expecting=filename

for A do
    case $A in

    -d)
	expecting=doptions ;;
			
    -f)
	format="Y" ;;

    -h)
	expecting=head ;;
			
    -o)
	output=dvi
	expecting=outputfile ;;

# some sample devices...
    -v)
	output="ver" ;;

    -q)
	output="qms" ;;

    -*)
	options="$options $A" ;;

    *)
	case $expecting in
	outputfile)
		outputfile="$A" ;;
	head)
		head="$A" ;;
	doptions)
		options="$options -d $A" ;;
	filename)
		files="$files $A" ;;
	esac
	expecting=filename ;;
    esac
done

if [ "$format" = "Y" ]; then
    if [ "$head" != "" ]; then
	$b $options -h "$head" $files
    else
	$b $options $files
    fi
    exit 0
fi

trap 'rm -f tgrnd$$.tex tgrnd$$.dvi tgrnd$$.log' 0 2 3 15

if [ "$head" != "" ]; then
    $b $options -h "$head" $files >tgrnd$$.tex
else
    $b $options $files >tgrnd$$.tex
fi
$tex $texoptions tgrnd$$.tex

# PUT OUTPUT HANDLING COMMANDS HERE.
case $output in
ver)
	;;
qms)
	;;
dvi)
#	if [ `expr $outputfile : '/*'` -eq 0 ]; then
#		outputfile=$mydir/$outputfile
#	fi
	mv tgrnd$$.dvi $outputfile
	;;
esac
