# call of the printer driver dvijep with the file $main_file,
#                                                    output into $prt_file
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc prt_dvijep {f austext} {

  upvar 1 $austext a

  global vv main_file prtoptions pg_start pg_end prmsel prt_file opsep printcops dirprefix
  global prtsuf

  set a ""
  writescr $f "[datime] $vv(dta1) \"[lindex [info level [info level]] 0].tcl\" $vv(dta2)\n"
  TestPut 4 "<$prmsel> <$main_file><$ pg_start><$pg_end> <$prtoptions><$opsep><$printcops>"

###################### delete the following lines after test ##############################
global email language
set a "${a}*** Procedure \"prt_dvijep\" in file \"prt_dvijep.tcl\" not tested up to now\n"
set a "${a}*** please test this fileand then remove the marked commands\n"
set a "${a}*** (test also file \"locals_$language/prt_dvijep.vst\")\n"
set a "${a}*** and send any modifications to $email  "; mybell 4; return 0
###################### stop deleting of lines here ########################################

  if {$dirprefix==""} {set mainfile $main_file} else {set mainfile [fileName $main_file]} 

  set opt1 "[lindex [split $prtoptions $opsep] 1]";# set driver options (except format)
  if {$printcops!="1"} {set opt1 "$opt1 -c$printcops"};# add number of copies to options
  set opt2 "[lindex [split $prtoptions $opsep] 2]";# set format dependent driver options

  set opt_seiten ""  

  if { $prmsel == "vstcommands" } {# list of commands from setting file prt_*.vst

    TestPut 4 "via vstcommands ($prtcmdmax): <$prtoptions> <$opt1><$opt2>"
    for {set c 1} {($c<=$prtcmdmax)&&($prtcmd($c)!="")} {incr c} {
      TestPut 4 "\tprtcmd($c)=<$prtcmd($c)>"
      set cmd [lindex $prtcmd($c) 0]
      #set opt "[eval list [lrange $prtcmd($c) 1 end]]"; #does not work with dvidvi: "(...)"
      set opt "[lrange $prtcmd($c) 1 end]"
      set opt [prtRegsub "$opt" $mainfile "$opt1" "$opt2" "$startpage" "$endpage"]
      writescr $f "\n[datime]: $cmd $opt"; update
      eval mkCmd_wait $f $cmd [list "$opt"]
    }

  } elseif {$prmsel=="rel" || $prmsel=="u_rel" || $prmsel=="g_rel"} {

    if {$pg_start=="$vv(dmstart)"} {set startpage 1}   else {set startpage $pg_start}
    if {$pg_end  =="$vv(dmend)"}   {set endpage  9999} else {set endpage  $pg_end}
    set incr "1"
    if {$prmsel=="u_rel"} {set startpage [expr "(($startpage/2)*2)+1"]; set incr "2"}
    if {$prmsel=="g_rel"} {set startpage [expr "(($startpage+1)/2)*2"]; set incr "2"}
    set opt_seiten "-o$startpage:$endpage:$incr"

    eval mkCmd_wait $f dvijep [list "$opt1 $opt2 $opt_seiten $mainfile"]
    if {$mainfile$prtsuf!=$prt_file} \
	{SigChldB; exec mv $mainfile$prtsuf $prt_file; SigChldU}

  } else {# error: unexpected value of $prmsel      

    set a "${a}*** $vv(aerr) (prt_dvijep.tcl): $vv(dt1) $prmsel\n"
    set a "${a}    $vv(adm)\n\n"
    mybell 3; return 1

  }
  
  return 0

}
