#################################################################################
# Setext file support
#
# Recognize and automatically mark 'setext'-encoded text files, like Tidbits.
#
# (Tom Pollard - October 1994)
#
#================================================================================


alpha::mode Setx 1.0.1 dummySetx {*.stx *.etx} 

#===============================================================================



newPref f autoMark 1 Setx
#=============================================================================
proc dummySetx {} {}

proc Setx::MarkFile {} {
    set pat1 {^(-+|=+)$}
    set end [maxPos]
    set pos [minPos]
    set l {}
    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $pat1 $pos} mtch]} {
    	set pos1 [lineStart [pos::math [lindex $mtch 0] - 1]]
    	set marker [string trimright [eval getText $mtch]]
    	set text [string trimright [getText $pos1 [nextLineStart $pos1]]]
		if {[string length $text] == [string length $marker]} {
			if {[string range $marker 0 0] == "-"} {
				set text "     $text"
			}
			regsub {/} $text {-} text
	        set inds($text) $pos1
	        lappend sects $text
	    }
	    set pos [nextLineStart [lindex $mtch 1]]
    }

    if {[info exists inds]} {
        foreach f $sects {
            set next [lineStart $inds($f)]
            setNamedMark $f $inds($f) $next $next
        }
    }
}
