## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "elecTemplateExamples.tcl"
 #                                    created: 29/7/97 {5:09:35 pm} 
 #                                last update: 31/1/1999 {2:31:49 pm} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1997-1998  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

proc file::year {} {
	return [lindex [lindex [mtime [now] long] 0] 3]
}

proc file::author {} {
    global user
    if {[info exists user(author)]} { 
	return $user(author) 
    } else { 
	return "author" 
    }
}

proc file::allRightsReserved {} {
    append t "Copyright (c) [file::year] [file::author]\r"
    append t "\r"
    append t "All rights reserved.\r"
}

proc file::allRightsReservedOrg {} {
    global user
    append t "Copyright (c) [file::year] $user(organisation)\r"
    append t "\r"
    append t "All rights reserved.\r"
}

proc file::copyrightNotice {} {
	append t "============================================================"
	append t "============\r"
	append t "              Copyright (c) [file::year] [file::author]\r"
	append t "============================================================"
	append t "============\r"
	append t "Permission to use, copy, modify, and distribute this softwar"
	append t "e and its\r"
	append t "documentation for any purpose and without fee is hereby gran"
	append t "ted,\r"
	append t "provided that the above copyright notice appear in all copie"
	append t "s and that\r"
	append t "both that the copyright notice and warranty disclaimer appea"
	append t "r in\r"
	append t "supporting documentation.\r"
	append t "\r[file::author] disclaims all warranties with regard to this "
	append t "software,\r"
	append t "including all implied warranties of merchantability and fitn"
	append t "ess.  In\r"
	append t "no event shall [file::author] be liable for any special, indir"
	append t "ect or\r"
	append t "consequential damages or any damages whatsoever resulting fr"
	append t "om loss of\r"
	append t "use, data or profits, whether in an action of contract, negl"
	append t "igence or\r"
	append t "other tortuous action, arising out of or in connection with "
	append t "the use or\r"
	append t "performance of this software.\r"
	append t "============================================================"
	append t "============\r"
}

proc file::seeFileLicenseTerms {} {
	append t "Copyright (c) [file::year]  [file::author]\r\r"
	append t "See the file \"license.terms\" for information on usage and r"
	append t "edistribution\r"
	append t "of this file, and for a DISCLAIMER OF ALL WARRANTIES.\r"
}

proc file::gnuPublicLicense {} {
	append t "Copyright (c) [file::year]  [file::author]\r"
	append t "\rThis program is free software; you can redistribute it and/"
	append t "or modify\r"
	append t "it under the terms of the GNU General Public License as publ"
	append t "ished by\r"
	append t "the Free Software Foundation; either version 2 of the Licens"
	append t "e, or\r"
	append t "(at your option) any later version.\r"
	append t "\rThis program is distributed in the hope that it will be use"
	append t "ful,\r"
	append t "but WITHOUT ANY WARRANTY; without even the implied warranty "
	append t "of\r"
	append t "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See th"
	append t "e\r"
	append t "GNU General Public License for more details.\r"
	append t "\rYou should have received a copy of the GNU General Public L"
	append t "icense\r"
	append t "along with this program; if not, write to the Free Software\r"
	append t "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\r"
}

proc file::none {} {}



