# First basic initialisation: (works with Alpha 7.2.1 or 8.0 development)
if {[catch {
    if {[info tclversion] < 8.0} {
	;proc namespace {cmd ns script} {if {$script != ""} {uplevel $script}}
	;proc variable {n} { global mode ; uplevel 1 [list upvar \#0 $mode::$n $n] }
	;proc renameMenuItem {args} {}
    } else {
	namespace eval alpha {
	    namespace eval index {}
	    namespace eval cache {}
	}
	namespace eval win {}
	if {[info commands scancontext] == ""} {
	    proc scancontext {cmd args} {
		switch -- $cmd {
		    "create" {
			uplevel 1 {
			    set __scan 0
			    while {[array exists scancontext$__scan]} {
				incr __scan
			    }
			    set scancontext[set __scan]() 1
			    return scancontext$__scan
			}
		    }
		    "delete" {
			upvar [lindex $args 0] scan
			unset scan
		    }
		}
	    }
	
	    proc scanmatch {scanid regexp script args} {
		if {[string match "-*" $scanid]} {
		    set flags $scanid
		    set scanid $regexp
		    set regexp [list $flags $script]
		    set script [lindex $args 0]
		} else {
		    set regexp [list -- $regexp]
		}
		upvar $scanid scan
		set scan($regexp) $script
		return $scanid
	    }
	
	    proc scanfile {scanid fid} {
		upvar $scanid scan
		upvar matchInfo m
		set m(linenum) 0
		set m(offset) 0
		set names [array names scan]
		while {[set count [gets $fid m(line)]] >= 0} {
		    incr m(linenum)
		    incr m(offset) [expr {$count +1}]
		    foreach reg $names {
			if {$reg == ""} {continue}
			if {[regexp [lindex $reg 0] [lindex $reg 1] $m(line) \
			  "" m(submatch0) m(submatch1) m(submatch2)]} {
			    incr m(offset) [expr {-[string length $m(submatch0)]}]
			    uplevel 1 $scan($reg)
			    incr m(offset) [string length $m(submatch0)]
			}
		    }
		}
	    }
	}
	if {[info commands objDialog] != ""} {
	    rename dialog ""
	    rename objDialog dialog
	}
	rename lsort __lsort
	proc lsort {args} {
	    if {[lindex $args 0] == "-ignore"} {
		eval __lsort -dictionary [lrange $args 1 end]
	    } else {
		eval __lsort $args
	    }
	}
	# Tcl 8.0 doesn't handle \t \r \n , but Tcl 8.1 will
	if {[info tclversion] == 8.0} {
	    rename regexp __regexp
	    proc regexp {args} {
		set i 0
		while {[string match -* [set a [lindex $args $i]]]} {
		    incr i
		    if {$a == "--"} {
			set a [lindex $args $i]
			break
		    }
		}
		__regsub -all "\\\\t" $a "\t" a
		__regsub -all "\\\\r" $a "\r" a
		__regsub -all "\\\\n" $a "\n" a
		__regsub -all "\\\\w" $a "\[a-zA-Z0-9_\]" a
		__regsub -all "\\\\s" $a "\[ \t\r\n\]" a
		uplevel __regexp [lreplace $args $i $i $a]
	    }
	    rename regsub __regsub
	    proc regsub {args} {
		set i 0
		while {[string match -* [set a [lindex $args $i]]]} {
		    incr i
		    if {$a == "--"} {
			set a [lindex $args $i]
			break
		    }
		}
		__regsub -all "\\\\" $a "" a
		__regsub -all "\\\\t" $a "\t" a
		__regsub -all "\\\\r" $a "\r" a
		__regsub -all "\\\\n" $a "\n" a
		__regsub -all "\\\\w" $a "\[a-zA-Z_\]" a
		__regsub -all "\\\\s" $a "\[ \t\r\n\]" a
		__regsub -all "" $a "\\\\" a
		uplevel __regsub [lreplace $args $i $i $a]
	    }
	}
    }    
    
    # Get Alpha's current name.
    regexp {"([^"]+)" "ALFA" } [processes] "" ALPHA
    set alpha::version [lindex [split [string trimleft [version] "Alpha Version"] ,] 0]
    # set AlphaTcl version (the version of this library of .tcl files)
    set alpha::tclversion 7.2.1b10
    if {[info commands startupText] != ""} {
	set for ""
	regexp { for [^ ,]+} [version] for
	startupText "Alpha$for $alpha::version, AlphaTcl $alpha::tclversion, Tcl [info patchlevel]"
	unset for
    }
    if {[regexp -nocase "for (ppc|68k)" [version]] || ![regexp "for" [version]]} {
	set alpha::platform "alpha"
    } 
    
    # PREFS points to a folder 'Alpha', we add the major version number
    append PREFS "-v[lindex [split ${alpha::version} .] 0]"
    if {![info exists alpha::modifier_keys]} {
	set alpha::modifier_keys [list "Command" "cmd" "Option" "opt"]
    }
    # useful proc
    if {[info tclversion] < 7.6} { 
	set tcl_platform(platform) macintosh
	# Alpha already has these two renamed internally
	# they need their argument packaged as a list!
	;proc mkdir {dir} {
	    oldMkdir [list $dir]
	}
	;proc rmdir {dir} {
	    oldRmdir [list $dir]
	}
	if {[info commands __file] == ""} {
	    rename file __file
	    ;proc file {cmd args} {
		switch -- $cmd {
		    "join" {
			regsub -all "::" [join $args ":"] ":" res
			return $res
		    }
		    "copy" {eval copyFile $args}
		    "rename" {eval moveFile $args}
		    "delete" {
			if {[file isdir [lindex $args 0]]} {
			    eval rmdir $args
			} else {
			    eval removeFile $args
			}
		    }
		    "mkdir" {eval mkdir $args}
		    "volumes" {
			# Thanks to Jon
			return [aebuild::result 'MACS' core getd ---- {obj {form:indx, want:type(cdis), seld:abso('all '), from:'null'()}} rtyp TEXT] 
		    }
		    "split" {
			return [split [lindex $args 0] :]
		    }
		    "attributes" {
			switch -- [lindex $args 1] {
			    "-readonly" {
				#__file stat [lindex $args 0] r
				if {[llength $args] > 2} {
				    # set read-only status
				} else {
				    # get read-only status
				    return [expr {![__file writable [lindex $args 0]]}]
				}
			    }
			    default {
				error "file attributes [lindex $args 1] unimplemented"
			    }
			}
			
		    }
		    "nativename" {
			return [lindex $args 0]
		    }
		    "pathtype" {
			# Not a perfect implementation, but not bad.
			set relative 1
			set path [lindex $args 0]
			foreach volume [file volumes] {
			    if {[string first $volume $path] == 0} {
				unset relative
				break
			    }
			}
			if {[info exists relative]} {
			    return "relative"
			} else {
			    return "absolute"
			}
		    }
		    default {uplevel 1 __file $cmd $args}
		}
	    }
	}
    } 
    # check if the user over-rides things
    if {[file exists [file join ${HOME} AlphaPrefs]] \
      && [file isdir [file join ${HOME} AlphaPrefs]]} {
	set PREFS [file join ${HOME} AlphaPrefs]
    } else {		
	if {![file exists $PREFS]} { 
	    if {[catch {file mkdir $PREFS}]} {
		alertnote "I cannot locate or create your preferences\
		  directory '$PREFS'.  From now on I'll try to use \
		  '[file join ${HOME} AlphaPrefs]' instead."
		set PREFS [file join ${HOME} AlphaPrefs]
		if {![file exists $PREFS]} { 
		    if {[catch {file mkdir $PREFS}]} {
			alertnote "Sorry, I couldn't make '$PREFS'.  Alpha\
			  requires a preferences directory to run.  Please fix\
			  this problem and then try to rerun Alpha.  Goodbye."
			quit
		    }
		}
	    }
	}
    }
    set alpha::noMenusYet 1
    
    # source v. important code
    source [file join $HOME Tcl SystemCode library.tcl]
    source [file join $HOME Tcl SystemCode coreFixes.tcl]
    set auto_path {}
    alpha::makeAutoPath 0 $skipPrefs
    
    # IMPORTANT: it is vital we get to this point in the startup sequence
    # without any errors.  From this point on if we hit any errors, we
    # should be able to handle them reasonably gracefully, although
    # even then we might force/ask the user to quit.  However errors prior
    # to this point probably can't even be dealt with in a useful way,
    # basically because we only load the 'unknown' procedure just above.

    # get known packages
    catch {cache::readContents index::feature}
    # if configuration has changed, rebuild indices
    if {[alpha::checkConfiguration]} {
	alertnote "You have recently installed or upgraded Alpha. \
	  This means I have to rebuild the index of all available\
	  packages, which will take a little while."
	# power-user can use 'option' to avoid the rebuild
	if {!([getModifiers] & 72)} {
	    alpha::makeIndices
	    rebuildTclIndices
	}
    }

    if {[alpha::package vcompare ${alpha::version} 7.2d1] < 0} {
	alertnote "This version of Alpha is too old.\
	  Upgrade from\
	  http://alpha.olm.net/ or\
	  ftp://ftp.ucsd.edu/pub/alpha/ \
	  \r\rI'll quit now."
	quit
    }
    # load the list of active packages from special cache
    namespace eval global {}
    if {!$skipPrefs} {
	catch {cache::readContents configuration}
	catch {unset mode::defaultfeatures}
    }
    if {![info exists global::features]} {
	set global::features ""
    }

# Now do all the more complex stuff:
# (from now on, avoid use of 'source'.  Prefer to use auto-loading)

    # pull in smarterSource and internationalMenus packages
    # if the user activated them
    lappend alpha::earlyPackages smarterSource internationalMenus
    alpha::package require Alpha
    foreach pkg [set alpha::earlyPackages] {
	if {[lsearch -exact ${global::features} $pkg] != -1} {
	    alpha::package require $pkg
	}
    }
    unset pkg
    # So we can handle times properly
    alpha::package require isoTime
    
    removeTemporaryFiles
    alpha::getDefinitions
    if {![llength ${global::features}]} {
	lappend global::features internationalMenus filesetMenu
	if {$tcl_platform(platform) == "macintosh"} {
	    lappend global::features internetConfigMenu eudoraMenu
	}
	if {!$skipPrefs} {
	    if {[dialog::yesno "Alpha contains a lot of useful additional functionality\
	      in the form of menus, packages and features.  Many of these provide\
	      basic things like completions, a recent files menu, keyboard macros,\
	      electric code insertion...\r\r  Would you like me to activate\
	      the standard feature set?  (Either\
	      way you can turn them on and off using the\
	      'Config->Preferences->Menus And Features' menu item)"]} {
		lappend global::features recentFilesMenu elecCompletions \
		  elecExpansions macros elecBindings emacs autoContinueComment
	    }
	}
    }
    if {!$skipPrefs} {
	# Read both scalar and array definitions from preferences folder.
	alpha::readUserDefs
	if {[key::optionPressed]} {
	}
    }
    # define v. important keyboard variables
    keys::keyboardChanged
    message "Building basic menus"
    menu::buildBasic
    message "Binding keys"
    if {![info exists alpha::haveBasicKeys]} {
	alpha::basicKeyBindings
    }
    alpha::keyBindings
    alpha::useElectricTemplates
    # Read in all packages, modes and menus.
    message "Reading in packages"
    alpha::findAllPlugins
    if {!$skipPrefs} {
	# read preferences file
	if {[catch {alpha::readUserPrefs} err]} {
	    append alpha::errorLog "\r" $err
	    unset err
	}
    }
    # call anything that's attached to my keyboard.
    hook::callAll keyboard $keyboard
    message "Building complete menus"
    # build all menus completely.
    alpha::buildMainMenus
    # insert menus
    global::insertAllMenus
    # Bind special keys
    bind::fromArray keys::specialBindings keys::specialProcs

# if we do anything else to a menu, it must now be rebuilt
unset alpha::noMenusYet

# couple of random things
alpha::makeColourList

# Add to chars considered part of words.
addAlphaChars {_}
# Call all startup hooks
hook::callAll startupHook *
# Alerts and readme's for the user:

    if {!$skipPrefs} {
	if {![info exists readReadme] \
	  || ([lindex $readReadme 0] != [alpha::package versions Alpha]) \
	  || ([lindex $readReadme 1] != [alpha::package versions AlphaTcl]) \
	} {
	    addDef readReadme [list [alpha::package versions Alpha] \
	      [alpha::package versions AlphaTcl]]
	    if {[llength [set files [glob -path \
	      [file join $HOME Help Readme] *]]]} {
		foreach f $files {
		    edit -r $f
		}
		unset f
		unset files
	    } else {
		alertnote "Alpha's readme file should be in\
		  '[file join $HOME Help]', but isn't.  You may wish\
		  to reinstall Alpha."
	    }
	} else {unset readReadme}
	
	if {[info exists alpha::readAtStartup]} {
	    foreach f ${alpha::readAtStartup} {
		catch {edit -r $f}
	    }
	    unset alpha::readAtStartup
	    lappend modifiedVars alpha::readAtStartup
	}
    }

} err]} {
    append alpha::errorLog "\r" $errorInfo
    if {![auto_load dialog::yesno] || ![auto_load dialog::alert]} {
	alertnote "That was a core startup error.  Alpha will probably\
	  not function correctly.  Press Ok to view the error."
	alertnote $errorInfo
    } else {
	if {[dialog::yesno -y "View the error" -n "Continue" \
	  "That was a core startup error.  Alpha will probably\
	  not function correctly."]} {
	    dialog::alert $errorInfo
	}
    }
}
if {[info exists alpha::errorLog]} {
    catch {
	new -n "* Alpha startup error log *" -info ${alpha::errorLog}
	unset alpha::errorLog
    }
}
# call these two procs to sort out the menu enabled state.
catch {
    menuEnableHook [expr {[win::Current] != ""}]
    requireOpenWindowsHook 2
}
message "Initialization Complete"



